/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeImpl;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J:\u0010\u000f\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/types/expressions/ValueParameterResolver;", "", "expressionTypingServices", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "constantExpressionEvaluator", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "(Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;)V", "resolveDefaultValue", "", "valueParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "jetParameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "resolveValueParameters", "valueParameters", "", "valueParameterDescriptors", "declaringScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "frontend"})
public final class ValueParameterResolver {
    private final ExpressionTypingServices expressionTypingServices;
    private final ConstantExpressionEvaluator constantExpressionEvaluator;

    public final void resolveValueParameters(@NotNull List<? extends KtParameter> valueParameters, @NotNull List<? extends ValueParameterDescriptor> valueParameterDescriptors, @NotNull LexicalScope declaringScope, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(valueParameters, (String)"valueParameters");
        Intrinsics.checkParameterIsNotNull(valueParameterDescriptors, (String)"valueParameterDescriptors");
        Intrinsics.checkParameterIsNotNull((Object)declaringScope, (String)"declaringScope");
        Intrinsics.checkParameterIsNotNull((Object)dataFlowInfo, (String)"dataFlowInfo");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        LexicalScopeImpl scopeForDefaultValue = new LexicalScopeImpl(declaringScope, declaringScope.getOwnerDescriptor(), false, null, LexicalScopeKind.DEFAULT_VALUE, null, null, 96, null);
        ExpressionTypingContext contextForDefaultValue = ExpressionTypingContext.newContext(trace, scopeForDefaultValue, dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE);
        for (Pair pair2 : CollectionsKt.zip((Iterable)valueParameterDescriptors, (Iterable)valueParameters)) {
            ValueParameterDescriptor descriptor2 = (ValueParameterDescriptor)pair2.component1();
            KtParameter parameter = (KtParameter)pair2.component2();
            ForceResolveUtil.forceResolveAllContents(descriptor2.getAnnotations());
            ExpressionTypingContext expressionTypingContext = contextForDefaultValue;
            Intrinsics.checkExpressionValueIsNotNull((Object)expressionTypingContext, (String)"contextForDefaultValue");
            this.resolveDefaultValue(descriptor2, parameter, expressionTypingContext);
        }
    }

    private final void resolveDefaultValue(ValueParameterDescriptor valueParameterDescriptor, KtParameter jetParameter, ExpressionTypingContext context) {
        if (!valueParameterDescriptor.declaresDefaultValue()) {
            return;
        }
        KtExpression ktExpression = jetParameter.getDefaultValue();
        if (ktExpression == null) {
            return;
        }
        KtExpression defaultValue = ktExpression;
        this.expressionTypingServices.getTypeInfo(defaultValue, (ResolutionContext)context.replaceExpectedType(valueParameterDescriptor.getType()));
        if (DescriptorUtils.isAnnotationClass(DescriptorResolver.getContainingClass(context.scope))) {
            KtExpression ktExpression2 = defaultValue;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"defaultValue");
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
            CompileTimeConstant<?> constant = this.constantExpressionEvaluator.evaluateExpression(ktExpression2, bindingTrace, valueParameterDescriptor.getType());
            if (constant == null || constant.getUsesNonConstValAsConstant()) {
                context.trace.report(Errors.ANNOTATION_PARAMETER_DEFAULT_VALUE_MUST_BE_CONSTANT.on((KtExpression)((PsiElement)defaultValue)));
            }
        }
    }

    public ValueParameterResolver(@NotNull ExpressionTypingServices expressionTypingServices, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator) {
        Intrinsics.checkParameterIsNotNull((Object)expressionTypingServices, (String)"expressionTypingServices");
        Intrinsics.checkParameterIsNotNull((Object)constantExpressionEvaluator, (String)"constantExpressionEvaluator");
        this.expressionTypingServices = expressionTypingServices;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
    }
}

