/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker;

import com.intellij.freemarker.lexer.FtlLexer;
import com.intellij.freemarker.psi.FtlCompositeElementType;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlLanguage;
import com.intellij.freemarker.psi.FtlParser;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class FtlParserDefinition
implements ParserDefinition {
    private static final TokenSet WHITE_SPACES = TokenSet.create((IElementType[])new IElementType[]{TokenType.WHITE_SPACE});
    private static final TokenSet myCommentTokens = TokenSet.create((IElementType[])new IElementType[]{FtlElementTypes.COMMENT_TEXT, FtlElementTypes.TERSE_COMMENT_START});
    public static final IFileElementType FTL_FILE = new IStubFileElementType("FTL_FILE", FtlLanguage.ANGLE_INSTANCE);

    @NotNull
    public Lexer createLexer(Project project) {
        FtlLexer ftlLexer = FtlLexer.createLexer();
        if (ftlLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlParserDefinition", "createLexer"));
        }
        return ftlLexer;
    }

    public PsiParser createParser(Project project) {
        return new FtlParser();
    }

    public IFileElementType getFileNodeType() {
        return FTL_FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = WHITE_SPACES;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlParserDefinition", "getWhitespaceTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = myCommentTokens;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlParserDefinition", "getCommentTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlParserDefinition", "getStringLiteralElements"));
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType type = node.getElementType();
        if (type instanceof FtlCompositeElementType) {
            PsiElement psiElement = ((FtlCompositeElementType)type).createPsiElement(node);
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlParserDefinition", "createElement"));
            }
            return psiElement;
        }
        throw new AssertionError((Object)("Unknown type: " + type));
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new FtlFile(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }
}

