/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.editorActions;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlTokenType;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.codeStyle.IndentHelperImpl;
import org.jetbrains.annotations.NotNull;

public class FreeMarkerEnterHandler
extends EnterHandlerDelegateAdapter {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/freemarker/editorActions/FreeMarkerEnterHandler", "preprocessEnter"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/freemarker/editorActions/FreeMarkerEnterHandler", "preprocessEnter"));
        }
        if (caretOffset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretOffset", "com/intellij/freemarker/editorActions/FreeMarkerEnterHandler", "preprocessEnter"));
        }
        if (caretAdvance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretAdvance", "com/intellij/freemarker/editorActions/FreeMarkerEnterHandler", "preprocessEnter"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/freemarker/editorActions/FreeMarkerEnterHandler", "preprocessEnter"));
        }
        if (!(file instanceof FtlFile)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int offset = (Integer)caretOffset.get();
        if (offset <= 0) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
        PsiElement at = file.findElementAt(offset);
        if (at == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiElement prev = file.findElementAt(offset - 1);
        if (prev == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if ((FreeMarkerEnterHandler.isOfType(at, FtlElementTypes.END_DIRECTIVE_START) || FreeMarkerEnterHandler.isOfType(at, FtlElementTypes.END_MACRO_START)) && FreeMarkerEnterHandler.isOfType(prev, FtlElementTypes.DIRECTIVE_END)) {
            originalHandler.execute(editor, dataContext);
            editor.getCaretModel().moveToOffset(offset);
            originalHandler.execute(editor, dataContext);
            int indentSize = CodeStyleSettingsManager.getSettings((Project)file.getProject()).getIndentSize(file.getFileType());
            String indentText = IndentHelperImpl.fillIndent((Project)file.getProject(), (FileType)file.getFileType(), (int)indentSize);
            editor.getDocument().insertString(editor.getCaretModel().getOffset(), (CharSequence)indentText);
            editor.getCaretModel().moveCaretRelatively(indentSize, 0, false, false, true);
            return EnterHandlerDelegate.Result.Stop;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static boolean isOfType(@NotNull PsiElement at, FtlTokenType type) {
        if (at == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "at", "com/intellij/freemarker/editorActions/FreeMarkerEnterHandler", "isOfType"));
        }
        ASTNode node = at.getNode();
        return node != null && node.getElementType() == type;
    }
}

