/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.inspections;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.actions.AbstractBatchSuppressByNoInspectionCommentFix;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.freemarker.psi.FtlCompositeElement;
import com.intellij.freemarker.psi.FtlInterpolation;
import com.intellij.freemarker.psi.FtlXmlTag;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FtlSuppressableInspection
extends LocalInspectionTool {
    private static final Pattern SUPPRESSION_PATTERN = Pattern.compile(".#--\\s*noinspection\\s+([a-zA-Z_0-9.-]+(\\s*,\\s*[a-zA-Z_0-9.-]+)*)\\s*\\w*\\s*--.");

    public boolean isSuppressedFor(@NotNull PsiElement place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/freemarker/inspections/FtlSuppressableInspection", "isSuppressedFor"));
        }
        FtlCompositeElement ftlElement = FtlSuppressableInspection.getTopmostFtlElement(place);
        return ftlElement != null && FtlSuppressableInspection.getCommentFor((PsiElement)ftlElement, this.getID()) != null;
    }

    @Nullable
    static PsiComment getCommentFor(@NotNull PsiElement ftlElement, @NotNull String inspectionId) {
        Matcher matcher;
        PsiElement prev;
        if (ftlElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ftlElement", "com/intellij/freemarker/inspections/FtlSuppressableInspection", "getCommentFor"));
        }
        if (inspectionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionId", "com/intellij/freemarker/inspections/FtlSuppressableInspection", "getCommentFor"));
        }
        int lineStart = FtlSuppressableInspection.getEolBefore(ftlElement);
        if (lineStart <= 0) {
            return null;
        }
        for (prev = ftlElement.getContainingFile().findElementAt(lineStart - 1); prev != null && StringUtil.isEmpty((String)prev.getText().trim()); prev = prev.getPrevSibling()) {
        }
        if (prev instanceof PsiComment && (matcher = SUPPRESSION_PATTERN.matcher(prev.getText())).matches() && SuppressionUtil.isInspectionToolIdMentioned((String)matcher.group(1), (String)inspectionId)) {
            return (PsiComment)prev;
        }
        return null;
    }

    private static int getEolBefore(PsiElement element) {
        return element.getContainingFile().getText().lastIndexOf(10, element.getTextRange().getStartOffset());
    }

    private static FtlCompositeElement getTopmostFtlElement(PsiElement place) {
        return (FtlCompositeElement)PsiTreeUtil.getParentOfType((PsiElement)place, (Class[])new Class[]{FtlInterpolation.class, FtlXmlTag.class});
    }

    @NotNull
    public SuppressQuickFix[] getBatchSuppressActions(@Nullable PsiElement element) {
        final String id = HighlightDisplayKey.find((String)this.getShortName()).getID();
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new AbstractBatchSuppressByNoInspectionCommentFix(id, false){

            @NotNull
            protected Language getCommentLanguage(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/inspections/FtlSuppressableInspection$1", "getCommentLanguage"));
                }
                Language language = element.getContainingFile().getLanguage();
                if (language == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlSuppressableInspection$1", "getCommentLanguage"));
                }
                return language;
            }

            @Nullable
            protected List<? extends PsiElement> getCommentsFor(@NotNull PsiElement container) {
                if (container == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/freemarker/inspections/FtlSuppressableInspection$1", "getCommentsFor"));
                }
                return ContainerUtil.createMaybeSingletonList((Object)FtlSuppressableInspection.getCommentFor(container, FtlSuppressableInspection.this.getID()));
            }

            protected void createSuppression(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiElement container) throws IncorrectOperationException {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/freemarker/inspections/FtlSuppressableInspection$1", "createSuppression"));
                }
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/inspections/FtlSuppressableInspection$1", "createSuppression"));
                }
                if (container == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/freemarker/inspections/FtlSuppressableInspection$1", "createSuppression"));
                }
                FtlSuppressableInspection.suppressForElement(container, id);
            }

            @NotNull
            public String getText() {
                if ("Suppress the inspection" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlSuppressableInspection$1", "getText"));
                }
                return "Suppress the inspection";
            }

            @Nullable
            public PsiElement getContainer(PsiElement context) {
                return FtlSuppressableInspection.getTopmostFtlElement(context);
            }
        }};
        if (suppressQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlSuppressableInspection", "getBatchSuppressActions"));
        }
        return suppressQuickFixArray;
    }

    static void suppressForElement(@NotNull PsiElement element, @NotNull String inspectionId) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/inspections/FtlSuppressableInspection", "suppressForElement"));
        }
        if (inspectionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionId", "com/intellij/freemarker/inspections/FtlSuppressableInspection", "suppressForElement"));
        }
        Project project = element.getProject();
        int lineStart = FtlSuppressableInspection.getEolBefore(element) + 1;
        PsiFile file = element.getContainingFile();
        String fileText = file.getText();
        String indent = fileText.substring(lineStart, CharArrayUtil.shiftForward((CharSequence)fileText, (int)lineStart, (String)" \t"));
        String suppressionText = "noinspection " + inspectionId;
        PsiComment comment = SuppressionUtil.createComment((Project)project, (String)suppressionText, (Language)element.getContainingFile().getViewProvider().getBaseLanguage());
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
        Document document = manager.getDocument(file);
        assert (document != null);
        document.insertString(lineStart, (CharSequence)(indent + comment.getText() + "\n"));
        manager.commitDocument(document);
    }
}

