/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.JspImportsPanel;
import com.intellij.application.options.JspWrappingPanel;
import com.intellij.application.options.TabbedLanguageCodeStylePanel;
import com.intellij.ide.highlighter.JspxFileType;
import com.intellij.lang.Language;
import com.intellij.lang.jspx.JSPXLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.Configurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import org.jetbrains.annotations.NotNull;

public class JspxCodeStyleSettingsProvider
extends CodeStyleSettingsProvider {
    @NotNull
    public Configurable createSettingsPage(CodeStyleSettings settings, CodeStyleSettings originalSettings) {
        final Language language = this.getLanguage();
        CodeStyleAbstractConfigurable codeStyleAbstractConfigurable = new CodeStyleAbstractConfigurable(settings, originalSettings, this.getConfigurableDisplayName()){

            protected CodeStyleAbstractPanel createPanel(CodeStyleSettings settings) {
                CodeStyleSettings currentSettings = this.getCurrentSettings();
                CodeStyleSettings settings1 = settings;
                return new TabbedLanguageCodeStylePanel(language, currentSettings, settings1){

                    protected void initTabs(CodeStyleSettings settings) {
                        this.addIndentOptionsTab(settings);
                        this.addTab(new JspWrappingPanel(settings, this.getFileType(), language));
                        this.addTab(new JspImportsPanel(settings, this.getFileType()));
                    }
                };
            }

            public String getHelpTopic() {
                return JspxCodeStyleSettingsProvider.this.getHelpTopic();
            }
        };
        if (codeStyleAbstractConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/JspxCodeStyleSettingsProvider", "createSettingsPage"));
        }
        return codeStyleAbstractConfigurable;
    }

    protected String getHelpTopic() {
        return "reference.settingsdialog.codestyle.jspx";
    }

    public String getConfigurableDisplayName() {
        return "JSPX";
    }

    @NotNull
    public Language getLanguage() {
        JSPXLanguage jSPXLanguage = JSPXLanguage.INSTANCE;
        if (jSPXLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/JspxCodeStyleSettingsProvider", "getLanguage"));
        }
        return jSPXLanguage;
    }

    @NotNull
    protected FileType getFileType() {
        JspxFileType jspxFileType = JspxFileType.INSTANCE;
        if (jspxFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/JspxCodeStyleSettingsProvider", "getFileType"));
        }
        return jspxFileType;
    }
}

