/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis.encoding;

import com.intellij.codeInsight.daemon.impl.analysis.encoding.XmlEncodingReference;
import com.intellij.codeInsight.daemon.impl.analysis.encoding.XmlEncodingReferenceProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class JspEncodingInAttributeReferenceProvider
extends XmlEncodingReferenceProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.analysis.encoding.XmlEncodingReferenceProvider");

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/encoding/JspEncodingInAttributeReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/analysis/encoding/JspEncodingInAttributeReferenceProvider", "getReferencesByElement"));
        }
        PsiReference[] psiReferenceArray = JspEncodingInAttributeReferenceProvider.getReferencesByElement(element);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/encoding/JspEncodingInAttributeReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    public static PsiReference[] getReferencesByElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/encoding/JspEncodingInAttributeReferenceProvider", "getReferencesByElement"));
        }
        LOG.assertTrue(element instanceof XmlAttributeValue);
        XmlAttributeValue value = (XmlAttributeValue)element;
        PsiElement parent = value.getParent();
        if (parent instanceof XmlAttribute) {
            XmlAttribute attribute = (XmlAttribute)parent;
            String name = attribute.getLocalName();
            if (name.equals("pageEncoding")) {
                return new PsiReference[]{new XmlEncodingReference(value, value.getValue(), JspEncodingInAttributeReferenceProvider.xmlAttributeValueRange((XmlAttributeValue)value), 1)};
            }
            if (name.equals("contentType")) {
                return JspEncodingInAttributeReferenceProvider.extractFromContentAttribute((XmlAttributeValue)value);
            }
        }
        return PsiReference.EMPTY_ARRAY;
    }
}

