/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.jsp;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.analysis.InsertRequiredAttributeFix;
import com.intellij.codeInspection.JspInspectionGroupNames;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jsp.JspBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.jsp.JspManager;
import com.intellij.psi.impl.source.jsp.jspXml.JspDirective;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.xml.util.XmlTagUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JspDirectiveInspection
extends LocalInspectionTool {
    @NonNls
    private static final String TAGLIB_DIRECTIVE = "taglib";
    @NonNls
    private static final String URI_ATT = "uri";
    @NonNls
    private static final String TAGDIR_ATT = "tagdir";

    @NotNull
    public String getGroupDisplayName() {
        String string = JspInspectionGroupNames.JSP_INSPECTIONS;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/JspDirectiveInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = JspBundle.message("jsp.directive.inspection", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/JspDirectiveInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("JspDirectiveInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/JspDirectiveInspection", "getShortName"));
        }
        return "JspDirectiveInspection";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/JspDirectiveInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/jsp/JspDirectiveInspection", "buildVisitor"));
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                if (tag instanceof JspDirective && JspDirectiveInspection.TAGLIB_DIRECTIVE.equals(tag.getName()) && tag.getAttributeValue(JspDirectiveInspection.URI_ATT) == null && tag.getAttributeValue(JspDirectiveInspection.TAGDIR_ATT) == null) {
                    JspFile jspFile = (JspFile)tag.getContainingFile();
                    XmlToken element = XmlTagUtil.getStartTagNameElement((XmlTag)tag);
                    assert (element != null);
                    JspManager manager = JspManager.getInstance((Project)jspFile.getProject());
                    holder.registerProblem((PsiElement)element, JspBundle.message("either.uri.or.tagdir.attribute.should.be.specified", new Object[0]), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new LocalQuickFix[]{new InsertRequiredAttributeFix(tag, JspDirectiveInspection.URI_ATT, manager.getPossibleTldUris(jspFile)), new InsertRequiredAttributeFix(tag, JspDirectiveInspection.TAGDIR_ATT, new String[0])});
                }
            }
        };
        if (xmlElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/JspDirectiveInspection", "buildVisitor"));
        }
        return xmlElementVisitor;
    }
}

