/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.jsp;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.JspInspectionGroupNames;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jsp.JspBundle;
import com.intellij.jsp.util.JspReferenceContributor;
import com.intellij.lang.properties.PrefixBasedPropertyReference;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import org.jetbrains.annotations.NotNull;

public class JspPropertiesInspection
extends LocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        String string = JspInspectionGroupNames.JSP_INSPECTIONS;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/JspPropertiesInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = JspBundle.message("jsp.properties.inspection", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/JspPropertiesInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("JspPropertiesInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/JspPropertiesInspection", "getShortName"));
        }
        return "JspPropertiesInspection";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/JspPropertiesInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/jsp/JspPropertiesInspection", "buildVisitor"));
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlAttribute(XmlAttribute attribute) {
                XmlAttributeValue attributeValue = attribute.getValueElement();
                if (attributeValue != null && attribute.getName().equals("key") && JspReferenceContributor.PROPERTIES_ELEMENT_FILTER.isAcceptable(null, (PsiElement)attributeValue)) {
                    PsiReference[] psiReferences;
                    for (PsiReference psiReference : psiReferences = attributeValue.getReferences()) {
                        if (!(psiReference instanceof PropertyReference) || ((PropertyReference)psiReference).multiResolve(false).length != 0 || psiReference instanceof PrefixBasedPropertyReference && ((PrefixBasedPropertyReference)psiReference).isDynamicPrefix()) continue;
                        holder.registerProblem(psiReference);
                    }
                }
            }
        };
        if (xmlElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/JspPropertiesInspection", "buildVisitor"));
        }
        return xmlElementVisitor;
    }
}

