/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jsp;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.jsp.NewJspLanguage;
import com.intellij.lang.jspx.JspFormattingPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.xml.JspBlock;
import com.intellij.psi.formatter.xml.ReadOnlyBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlPolicy;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.PsiBasedFormatterModelWithShiftIndentInside;
import com.intellij.psi.impl.source.jsp.jspXml.JspXmlRootTag;
import com.intellij.psi.xml.XmlTag;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JspFormattingModelBuilder
implements FormattingModelBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.jsp.NewJspLanguage");

    @NotNull
    public FormattingModel createModel(PsiElement element, CodeStyleSettings settings) {
        PsiFile psiFile = element.getContainingFile();
        FormattingDocumentModelImpl documentModel = FormattingDocumentModelImpl.createOn((PsiFile)psiFile);
        Block rootBlock = JspFormattingModelBuilder.createJspRoot((PsiElement)psiFile, settings, (FormattingDocumentModel)documentModel);
        PsiBasedFormatterModelWithShiftIndentInside psiBasedFormatterModelWithShiftIndentInside = new PsiBasedFormatterModelWithShiftIndentInside(psiFile, rootBlock, documentModel);
        if (psiBasedFormatterModelWithShiftIndentInside == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/JspFormattingModelBuilder", "createModel"));
        }
        return psiBasedFormatterModelWithShiftIndentInside;
    }

    public TextRange getRangeAffectingIndent(PsiFile file, int offset, ASTNode elementAtOffset) {
        return null;
    }

    private static Block createJspRoot(PsiElement element, CodeStyleSettings settings, FormattingDocumentModel documentModel) {
        PsiFile file = element.getContainingFile();
        Language baseLanguage = JspPsiUtil.getJspFile((PsiElement)file).getViewProvider().getTemplateDataLanguage();
        if (baseLanguage == StdLanguages.HTML || baseLanguage == StdLanguages.XHTML) {
            Set psiRoots = file.getViewProvider().getLanguages();
            LOG.assertTrue(psiRoots.size() == 3);
            ASTNode rootNode = SourceTreeToPsiMap.psiElementToTree((PsiElement)file.getViewProvider().getPsi((Language)NewJspLanguage.INSTANCE));
            return new JspBlock(rootNode, null, null, (XmlFormattingPolicy)new JspFormattingPolicy(settings, documentModel), null, null);
        }
        if (baseLanguage == StdLanguages.XML) {
            Set psiRoots = file.getViewProvider().getLanguages();
            LOG.assertTrue(psiRoots.size() == 3);
            ASTNode rootNode = SourceTreeToPsiMap.psiElementToTree((PsiElement)file.getViewProvider().getPsi((Language)NewJspLanguage.INSTANCE));
            return new JspBlock(rootNode, null, null, (XmlFormattingPolicy)new XmlPolicyWithJspXmlTag(settings, documentModel), null, null);
        }
        FormattingModelBuilder builder = (FormattingModelBuilder)LanguageFormatting.INSTANCE.forLanguage(baseLanguage);
        if (builder != null) {
            return builder.createModel((PsiElement)file.getViewProvider().getPsi(baseLanguage), settings).getRootBlock();
        }
        return new ReadOnlyBlock((ASTNode)file.getNode());
    }

    public static class XmlPolicyWithJspXmlTag
    extends XmlPolicy {
        public XmlPolicyWithJspXmlTag(CodeStyleSettings settings, FormattingDocumentModel documentModel) {
            super(settings, documentModel);
        }

        public boolean indentChildrenOf(XmlTag parentTag) {
            return !(parentTag instanceof JspXmlRootTag);
        }
    }
}

