/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jsp;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.daemon.UnusedImportProvider;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.jsp.JspSpiUtil;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspIncludedFileImplicitUsageProvider
implements ImplicitUsageProvider,
UnusedImportProvider {
    public boolean isImplicitRead(PsiElement element) {
        Query<PsiReference> query = this.getSearcher(element);
        if (query == null) {
            return false;
        }
        for (PsiReference reference : query) {
            PsiExpression expression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), PsiExpression.class, (boolean)false);
            if (expression == null || !PsiUtil.isAccessedForReading((PsiExpression)expression)) continue;
            return true;
        }
        return false;
    }

    public boolean isImplicitUsage(PsiElement element) {
        Query<PsiReference> query = this.getSearcher(element);
        return query != null && query.findFirst() != null;
    }

    @Nullable
    private Query<PsiReference> getSearcher(PsiElement element) {
        return this.isUnusedImportEnabled(element) ? ReferencesSearch.search((PsiElement)element) : null;
    }

    public boolean isImplicitWrite(PsiElement element) {
        Query<PsiReference> query = this.getSearcher(element);
        if (query == null) {
            return false;
        }
        for (PsiReference reference : query) {
            PsiExpression expression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), PsiExpression.class);
            if (expression == null || !PsiUtil.isAccessedForWriting((PsiExpression)expression)) continue;
            return true;
        }
        return false;
    }

    public boolean isUnusedImportEnabled(@NotNull PsiElement element) {
        boolean doubleCheckUsages;
        JspFile jspFile;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/jsp/JspIncludedFileImplicitUsageProvider", "isUnusedImportEnabled"));
        }
        return JspPsiUtil.isInJspFile((PsiElement)element) && (jspFile = JspPsiUtil.getJspFile((PsiElement)element)) != null && (doubleCheckUsages = JspSpiUtil.isIncludedOrIncludesSomething((JspFile)jspFile));
    }
}

