/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.jsp.JspManager;
import com.intellij.psi.impl.source.jsp.JspManagerImpl;
import com.intellij.psi.impl.source.resolve.reference.impl.CachingReference;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class JspUriReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspUriReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspUriReferenceProvider", "getReferencesByElement"));
        }
        if (element instanceof XmlAttributeValue) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new UriReference((XmlAttributeValue)element)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspUriReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspUriReferenceProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    static class UriReference
    extends CachingReference
    implements EmptyResolveMessageProvider {
        private final XmlAttributeValue myElement;

        UriReference(XmlAttributeValue element) {
            this.myElement = element;
        }

        public PsiElement getElement() {
            return this.myElement;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = XmlErrorMessages.message((String)"cannot.resolve.taglib.uri", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspUriReferenceProvider$UriReference", "getUnresolvedMessagePattern"));
            }
            return string;
        }

        public TextRange getRangeInElement() {
            return this.myElement.getValueTextRange().shiftRight(-this.myElement.getTextRange().getStartOffset());
        }

        public PsiElement resolveInner() {
            String uri = this.getCanonicalText();
            if (uri.startsWith("urn:jsptagdir:")) {
                return null;
            }
            JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)this.myElement.getContainingFile());
            return JspManager.getInstance((Project)this.myElement.getProject()).getTldFileByUri(uri, jspFile);
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.myElement.getValue();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspUriReferenceProvider$UriReference", "getCanonicalText"));
            }
            return string;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            return null;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspUriReferenceProvider$UriReference", "bindToElement"));
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)this.myElement.getContainingFile());
            Object[] possibleTldUris = JspManagerImpl.getInstance(jspFile.getProject()).getPossibleTldUris(jspFile);
            Object[] objectArray = ContainerUtil.mapNotNull((Object[])possibleTldUris, (Function)((NullableFunction)s -> s.startsWith("urn:jsptagdir:") ? null : s)).toArray();
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspUriReferenceProvider$UriReference", "getVariants"));
            }
            return objectArray;
        }
    }
}

