/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.pics;

import org.w3c.jigsaw.forms.URLDecoder;
import org.w3c.jigsaw.frames.PostableFrame;
import org.w3c.jigsaw.http.HTTPException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.pics.LabelBureauResource;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.ProtocolException;

public class LabelBureauFrame
extends PostableFrame {
    protected LabelBureauResource labelb = null;

    public void registerResource(FramedResource framedResource) {
        super.registerOtherResource(framedResource);
        if (framedResource instanceof LabelBureauResource) {
            this.labelb = (LabelBureauResource)framedResource;
        }
    }

    protected String[] parseURLs(String[] stringArray) {
        if (stringArray[0] == null) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].charAt(0) == '\"') {
                int n = stringArray[i].length();
                if (stringArray[i].charAt(n - 1) != '\"') continue;
                stringArray2[i] = stringArray[i].substring(1, n - 1);
                continue;
            }
            stringArray2[i] = stringArray[i];
        }
        return stringArray2;
    }

    protected int parseFormat(Request request, String string) throws HTTPException {
        if (string == null) {
            return 3;
        }
        if (string.equals("minimal")) {
            return 1;
        }
        if (string.equals("short")) {
            return 2;
        }
        if (string.equals("full")) {
            return 3;
        }
        if (string.equals("signed")) {
            return 4;
        }
        Reply reply = request.makeReply(400);
        reply.setContent("Unknown label format: " + string);
        throw new HTTPException(reply);
    }

    public Reply handle(Request request, URLDecoder uRLDecoder) throws ProtocolException {
        if (this.labelb == null) {
            Reply reply = request.makeReply(500);
            reply.setContent("LabelBureauFrame not configured properly: must be attached to a LabelBureauResource.");
            throw new HTTPException(reply);
        }
        String string = uRLDecoder.getValue("opt");
        String[] stringArray = this.parseURLs(uRLDecoder.getMultipleValues("u"));
        int n = this.parseFormat(request, uRLDecoder.getValue("format"));
        String[] stringArray2 = this.parseURLs(uRLDecoder.getMultipleValues("s"));
        if (stringArray2 == null) {
            stringArray2 = this.labelb.getServices();
        }
        if (stringArray2 == null || stringArray2.length == 0) {
            return this.labelb.makePICSErrorReply(request, "no-ratings \"unknown service\"");
        }
        if (this.labelb.getDebugFlag()) {
            int n2;
            System.out.println("******** PICS REQUEST ********");
            System.out.println("opt      : " + string);
            System.out.println("format   : " + uRLDecoder.getValue("format"));
            System.out.print("services : ");
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                System.out.println(stringArray2[n2]);
            }
            System.out.print("urls     : ");
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                System.out.println(stringArray[n2]);
            }
            System.out.println("******************************");
        }
        if (string.equals("generic")) {
            return this.labelb.getGenericLabels(request, n, stringArray, stringArray2, uRLDecoder);
        }
        if (string.equals("normal")) {
            return this.labelb.getNormalLabels(request, n, stringArray, stringArray2, uRLDecoder);
        }
        if (string.equals("tree")) {
            return this.labelb.getTreeLabels(request, n, stringArray, stringArray2, uRLDecoder);
        }
        if (string.equals("generic+tree")) {
            return this.labelb.getGenericTreeLabels(request, n, stringArray, stringArray2, uRLDecoder);
        }
        Reply reply = request.makeReply(400);
        reply.setContent("Invalid label bureau query, bad option: " + string);
        throw new HTTPException(reply);
    }
}

