/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.cache;

import java.util.Hashtable;
import org.w3c.tools.resources.AttributeHolder;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.IntegerAttribute;
import org.w3c.tools.resources.LongAttribute;
import org.w3c.tools.resources.SimpleAttribute;
import org.w3c.www.protocol.http.cache.CacheGeneration;
import org.w3c.www.protocol.http.cache.CachedResource;

public class StoreState
extends AttributeHolder {
    protected static int ATTR_CURRENT_GENERATION = -1;
    protected static int ATTR_NB_GENERATION = -1;
    protected static int ATTR_BYTE_COUNT = -1;
    protected static int ATTR_STORE_COUNT = -1;
    protected static int ATTR_CR_COUNT = -1;
    protected static int ATTR_ENTRY_NUM = -1;
    private int currentGeneration;
    private int nbGeneration;
    private int entryNum;
    private long byteCount;
    private long storeCount;
    private int crCount;

    public void sync() {
        this.setValue(ATTR_CURRENT_GENERATION, (Object)new Integer(this.currentGeneration));
        this.setValue(ATTR_NB_GENERATION, (Object)new Integer(this.nbGeneration));
        this.setValue(ATTR_ENTRY_NUM, (Object)new Integer(this.entryNum));
        this.setValue(ATTR_BYTE_COUNT, (Object)new Long(this.byteCount));
        this.setValue(ATTR_STORE_COUNT, (Object)new Long(this.storeCount));
        this.setValue(ATTR_CR_COUNT, (Object)new Integer(this.crCount));
    }

    public synchronized int incrCurrentGeneration() {
        return ++this.currentGeneration;
    }

    public synchronized int getCurrentGeneration() {
        return this.currentGeneration;
    }

    public synchronized int getNbGeneration() {
        return this.nbGeneration;
    }

    public synchronized long getByteCount() {
        return this.byteCount;
    }

    public synchronized long getStoreCount() {
        return this.storeCount;
    }

    public synchronized int getCrCount() {
        return this.crCount;
    }

    public synchronized int incrEntryNum() {
        return ++this.entryNum;
    }

    public synchronized int getEntryNum() {
        return this.entryNum;
    }

    public synchronized int incrGenerationNum() {
        return ++this.nbGeneration;
    }

    public synchronized int decrGenerationNum() {
        return --this.nbGeneration;
    }

    public synchronized void notifyGenerationCreated(CacheGeneration cacheGeneration) {
        this.storeCount += cacheGeneration.getStoredByteCount();
        this.byteCount += cacheGeneration.getCachedByteCount();
        this.crCount += cacheGeneration.getCRCount();
        cacheGeneration.setLoaded(true);
        ++this.nbGeneration;
    }

    public synchronized void notifyGenerationLoaded(CacheGeneration cacheGeneration) {
        this.byteCount += cacheGeneration.getCachedByteCount();
        this.crCount += cacheGeneration.getCRCount();
    }

    public synchronized void notifyGenerationUnloaded(CacheGeneration cacheGeneration) {
        this.byteCount -= cacheGeneration.getCachedByteCount();
        this.crCount -= cacheGeneration.getCRCount();
        cacheGeneration.unload();
    }

    public synchronized void notifyResourceAdded(CachedResource cachedResource, long l) {
        long l2 = cachedResource.getCurrentLength();
        this.storeCount += l2 - l;
        this.byteCount += l2;
        ++this.crCount;
    }

    public synchronized void notifyResourceReplaced(CachedResource cachedResource, long l) {
        long l2 = cachedResource.getCurrentLength();
        long l3 = l2 - l;
        this.storeCount += l2;
        this.byteCount += l3;
    }

    public synchronized void notifyResourceRemoved(CachedResource cachedResource) {
        this.byteCount -= (long)cachedResource.getCurrentLength();
        --this.crCount;
    }

    public synchronized void notifyResourceToBeDeleted(CachedResource cachedResource) {
        this.byteCount -= (long)cachedResource.getCurrentLength();
        --this.crCount;
    }

    public synchronized void notifyResourceDeleted(CachedResource cachedResource) {
        this.storeCount -= (long)cachedResource.getCurrentLength();
    }

    public void pickleValues(Hashtable hashtable) {
        super.pickleValues(hashtable);
        this.currentGeneration = this.getInt(ATTR_CURRENT_GENERATION, 0);
        this.nbGeneration = this.getInt(ATTR_NB_GENERATION, 0);
        this.entryNum = this.getInt(ATTR_ENTRY_NUM, 0);
        this.byteCount = this.getLong(ATTR_BYTE_COUNT, 0L);
        this.storeCount = this.getLong(ATTR_STORE_COUNT, 0L);
        this.crCount = this.getInt(ATTR_CR_COUNT, 0);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n>>> Store State <<<");
        stringBuffer.append("\n  Store count          : ").append(this.storeCount);
        stringBuffer.append("\n  Byte count           : ").append(this.byteCount);
        stringBuffer.append("\n  CR count             : ").append(this.crCount);
        stringBuffer.append("\n  Current Generation   : ").append(this.currentGeneration);
        stringBuffer.append("\n  Number of generation : ").append(this.nbGeneration);
        stringBuffer.append("\n  Entry number         : ").append(this.entryNum);
        return stringBuffer.toString();
    }

    static {
        SimpleAttribute simpleAttribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.www.protocol.http.cache.StoreState");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        simpleAttribute = new IntegerAttribute("current-generation", null, 1);
        ATTR_CURRENT_GENERATION = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new IntegerAttribute("nb-generation", null, 1);
        ATTR_NB_GENERATION = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new IntegerAttribute("entry-num", null, 1);
        ATTR_ENTRY_NUM = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new LongAttribute("byte-count", null, 1);
        ATTR_BYTE_COUNT = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new LongAttribute("store-count", null, 1);
        ATTR_STORE_COUNT = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new IntegerAttribute("cr-count", null, 1);
        ATTR_CR_COUNT = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
    }
}

