/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.Spliterator;
import java.util.function.Consumer;

final class PermutationSpliterator
implements Spliterator<int[]> {
    private static final long[] factorials = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};
    private final int[] value;
    private long remainingSize;
    private final long fence;

    public PermutationSpliterator(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Length must be non-negative");
        }
        if (length >= factorials.length) {
            throw new IllegalArgumentException("Length " + length + " is bigger than " + factorials.length + ": not supported");
        }
        this.value = new int[length];
        for (int i = 0; i < length; ++i) {
            this.value[i] = i;
        }
        this.fence = this.remainingSize = factorials[length];
    }

    public PermutationSpliterator(int[] startValue, long fence, long remainingSize) {
        this.value = startValue;
        this.fence = fence;
        this.remainingSize = remainingSize;
    }

    @Override
    public boolean tryAdvance(Consumer<? super int[]> action) {
        if (this.remainingSize == 0L) {
            return false;
        }
        int[] value = this.value;
        action.accept((int[])value.clone());
        if (--this.remainingSize > 0L) {
            int r = value.length - 1;
            int k = r - 1;
            while (value[k] > value[k + 1]) {
                --k;
            }
            int vk = value[k];
            int l = r;
            while (vk > value[l]) {
                --l;
            }
            value[k] = value[l];
            value[l] = vk;
            ++k;
            while (k < r) {
                int tmp = value[k];
                value[k] = value[r];
                value[r] = tmp;
                ++k;
                --r;
            }
        }
        return true;
    }

    @Override
    public Spliterator<int[]> trySplit() {
        long newPos;
        if (this.remainingSize <= 1L) {
            return null;
        }
        int[] newValue = (int[])this.value.clone();
        long used = -1L;
        long newRemainingSize = this.remainingSize / 2L;
        long s = newPos = this.fence - this.remainingSize + newRemainingSize;
        for (int i = 0; i < this.value.length; ++i) {
            long f = factorials[this.value.length - i - 1];
            int rem = (int)(s / f);
            s %= f;
            int idx = -1;
            while (rem >= 0) {
                idx = Long.numberOfTrailingZeros(used >> idx + 1) + idx + 1;
                --rem;
            }
            used &= (long)(~(1 << idx));
            this.value[i] = idx;
        }
        PermutationSpliterator prefixSpliterator = new PermutationSpliterator(newValue, newPos, newRemainingSize);
        this.remainingSize -= newRemainingSize;
        return prefixSpliterator;
    }

    @Override
    public long estimateSize() {
        return this.remainingSize;
    }

    @Override
    public int characteristics() {
        return 17744;
    }
}

