/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.quirksmode;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.XmlTagPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.jetbrains.quirksmode.CssHtmlPatternUtil;
import com.jetbrains.quirksmode.CssPatterns;
import com.jetbrains.quirksmode.HtmlPatterns;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlTagPattern
extends XmlTagPattern<HtmlTagPattern> {
    private static final InitialPatternCondition<XmlTag> CONDITION = new InitialPatternCondition<XmlTag>(XmlTag.class){

        public boolean accepts(@Nullable Object o, ProcessingContext context) {
            return o instanceof XmlTag;
        }
    };

    public HtmlTagPattern() {
        super(CONDITION);
    }

    public HtmlTagPattern withStyle(@NotNull @NonNls String propertyName, String ... values) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/jetbrains/quirksmode/HtmlTagPattern", "withStyle"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/jetbrains/quirksmode/HtmlTagPattern", "withStyle"));
        }
        return this.withCssDeclarations((ElementPattern)StandardPatterns.collection(CssDeclaration.class).atLeastOne((ElementPattern)CssPatterns.cssDeclaration().withPropertyName(propertyName).withValue(values)));
    }

    public HtmlTagPattern withStyle(@NotNull @NonNls String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/jetbrains/quirksmode/HtmlTagPattern", "withStyle"));
        }
        return this.withCssDeclarations((ElementPattern)StandardPatterns.collection(CssDeclaration.class).atLeastOne((ElementPattern)CssPatterns.cssDeclaration().withPropertyName(propertyName)));
    }

    public HtmlTagPattern withNonZeroStyle(@NotNull @NonNls String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/jetbrains/quirksmode/HtmlTagPattern", "withNonZeroStyle"));
        }
        return this.withCssDeclarations((ElementPattern)StandardPatterns.collection(CssDeclaration.class).atLeastOne((ElementPattern)CssPatterns.cssDeclaration().withPropertyName(propertyName).withNonZeroLength(propertyName)));
    }

    public HtmlTagPattern withStyle(@NotNull @NonNls String propertyName, @NotNull ElementPattern pattern) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/jetbrains/quirksmode/HtmlTagPattern", "withStyle"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/jetbrains/quirksmode/HtmlTagPattern", "withStyle"));
        }
        return this.withCssDeclarations((ElementPattern)StandardPatterns.collection(CssDeclaration.class).atLeastOne((ElementPattern)CssPatterns.cssDeclaration().withPropertyName(propertyName).withValue(pattern)));
    }

    public HtmlTagPattern withoutStyle(@NotNull @NonNls String propertyName, @NotNull String propertyValue) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/jetbrains/quirksmode/HtmlTagPattern", "withoutStyle"));
        }
        if (propertyValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyValue", "com/jetbrains/quirksmode/HtmlTagPattern", "withoutStyle"));
        }
        return (HtmlTagPattern)this.and((ElementPattern)StandardPatterns.not((ElementPattern)this.withStyle(propertyName, propertyValue)));
    }

    public HtmlTagPattern withCssDeclarations(final @NotNull ElementPattern declarationPattern) {
        if (declarationPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationPattern", "com/jetbrains/quirksmode/HtmlTagPattern", "withCssDeclarations"));
        }
        return (HtmlTagPattern)this.with((PatternCondition)new PatternCondition<XmlTag>("withCssDeclarations"){

            public boolean accepts(@NotNull XmlTag xmlTag, ProcessingContext context) {
                if (xmlTag == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlTag", "com/jetbrains/quirksmode/HtmlTagPattern$2", "accepts"));
                }
                CssDeclaration[] styles = CssHtmlPatternUtil.getStyles((PsiElement)xmlTag, context.getSharedContext());
                List<Object> list = styles != null ? Arrays.asList(styles) : Collections.emptyList();
                return declarationPattern.accepts(list, context);
            }
        });
    }

    public HtmlTagPattern withAtLeastOneStyle(String ... propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/jetbrains/quirksmode/HtmlTagPattern", "withAtLeastOneStyle"));
        }
        return this.withCssDeclarations((ElementPattern)StandardPatterns.collection(CssDeclaration.class).atLeastOne((ElementPattern)CssPatterns.cssDeclaration().withPropertyName(propertyName)));
    }

    public HtmlTagPattern isBlock() {
        return (HtmlTagPattern)this.with((PatternCondition)new PatternCondition<XmlTag>("isBlock"){

            public boolean accepts(@NotNull XmlTag xmlTag, ProcessingContext context) {
                if (xmlTag == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlTag", "com/jetbrains/quirksmode/HtmlTagPattern$3", "accepts"));
                }
                String displayStyle = CssHtmlPatternUtil.getStyle((PsiElement)xmlTag, "display", context.getSharedContext());
                return "block".equals(displayStyle);
            }
        });
    }

    public HtmlTagPattern isInline() {
        return (HtmlTagPattern)this.and((ElementPattern)StandardPatterns.not((ElementPattern)this.isBlock()));
    }

    public HtmlTagPattern inQuirksMode() {
        return (HtmlTagPattern)this.inside((ElementPattern)HtmlPatterns.htmlFile().inQuirksMode());
    }
}

