/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.library.JSLibReferenceResolver;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptReferenceContributor
extends PsiReferenceContributor {
    public static final ElementPattern<JSLiteralExpression> REQUIRE_ARG_PLACE = PlatformPatterns.psiElement(JSLiteralExpression.class).with((PatternCondition)new PatternCondition<JSLiteralExpression>("CommonJS.require"){

        public boolean accepts(@NotNull JSLiteralExpression expression, ProcessingContext context) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/javascript/JavaScriptReferenceContributor$1", "accepts"));
            }
            JSCallExpression callExpression = JSUtils.findCallExprByArg((PsiElement)expression);
            return callExpression != null && callExpression.isRequireCall();
        }
    });
    public static final ElementPattern<JSLiteralExpression> SYSTEM_IMPORT_PLACE = PlatformPatterns.psiElement(JSLiteralExpression.class).with((PatternCondition)new PatternCondition<JSLiteralExpression>("SystemJS.import"){

        public boolean accepts(@NotNull JSLiteralExpression expression, ProcessingContext context) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/javascript/JavaScriptReferenceContributor$2", "accepts"));
            }
            JSReferenceExpression methodExpression = JSUtils.getMethodNameIfInsideCall(expression.getParent());
            return JSSymbolUtil.isAccurateReferenceExpressionName(methodExpression, "System", "import");
        }
    });
    private static final THashSet<String> ourJQueryMethodsWithSelectors = new THashSet(Arrays.asList("children", "find", "next", "nextAll", "nextUntil", "parent", "parents", "parentsUntil", "prev", "prevAll", "prevUntil", "siblings", "closest"));
    private static final THashSet<String> ourJQueryMethodsWithClassNames = new THashSet(Arrays.asList("addClass", "removeClass", "toggleClass", "hasClass"));

    public static boolean isRawHtmlJQuery(String selectorText) {
        return selectorText.startsWith("<", 1) && selectorText.length() > 2 && Character.isJavaIdentifierStart(selectorText.charAt(2));
    }

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/javascript/JavaScriptReferenceContributor", "registerReferenceProviders"));
        }
        XmlUtil.registerXmlAttributeValueReferenceProvider((PsiReferenceRegistrar)registrar, (String[])new String[]{"src"}, (ElementFilter)new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                if (!(element instanceof PsiElement)) {
                    return false;
                }
                PsiElement e = (PsiElement)element;
                if (e instanceof XmlAttributeValue) {
                    return JSLibraryUtil.containsLibURL(((XmlAttributeValue)e).getValue());
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }, (PsiReferenceProvider)new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/JavaScriptReferenceContributor$4", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JavaScriptReferenceContributor$4", "getReferencesByElement"));
                }
                if (element instanceof XmlAttributeValue) {
                    PsiReference[] psiReferenceArray = new PsiReference[]{JSLibReferenceResolver.createReference((XmlAttributeValue)element)};
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JavaScriptReferenceContributor$4", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JavaScriptReferenceContributor$4", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
        });
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(JSLiteralExpression.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                JSExpression methodExpression;
                PsiElement grandParent;
                PsiElement parent = ((PsiElement)element).getParent();
                if (parent instanceof JSAssignmentExpression) {
                    JSExpression lOperand = ((JSAssignmentExpression)parent).getLOperand();
                    String text = lOperand == null ? null : lOperand.getText();
                    return text != null && lOperand instanceof JSDefinitionExpression && (text.endsWith("location.href") || text.equals("location") || text.equals("window.location") || text.endsWith("location.pathname"));
                }
                if (parent instanceof JSArgumentList && (grandParent = parent.getParent()) instanceof JSCallExpression && (methodExpression = ((JSCallExpression)grandParent).getMethodExpression()) instanceof JSReferenceExpression) {
                    String text = methodExpression.getText();
                    return text != null && (text.endsWith("location.assign") || text.endsWith("location.reload"));
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        })), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(final @NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/JavaScriptReferenceContributor$5", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JavaScriptReferenceContributor$5", "getReferencesByElement"));
                }
                FileReference[] fileReferenceArray = new FileReferenceSet(StringUtil.unquoteString((String)element.getText()), element, 1, this, false){

                    protected Collection<PsiFileSystemItem> getExtraContexts() {
                        return 1.getAbsoluteTopLevelDirLocations((PsiFile)element.getContainingFile());
                    }

                    protected boolean isSoft() {
                        return true;
                    }
                }.getAllReferences();
                if (fileReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JavaScriptReferenceContributor$5", "getReferencesByElement"));
                }
                return fileReferenceArray;
            }
        });
    }

    public static boolean isSimpleCss(String text) {
        return JavaScriptReferenceContributor.skipChars(text, false, false) == text.length();
    }

    public static int skipChars(String text, boolean allowDotsOrSharps, boolean allowWhiteSpace) {
        int offset;
        boolean seenDotOrSharp = !allowDotsOrSharps;
        int length = text.length();
        for (offset = 0; offset < length; ++offset) {
            char c = text.charAt(offset);
            if (Character.isWhitespace(c)) {
                if (allowWhiteSpace || offset >= length - 1) continue;
                break;
            }
            if (c == '.' || c == '#') {
                if (seenDotOrSharp) break;
                seenDotOrSharp = true;
                continue;
            }
            if (!JavaScriptReferenceContributor.isSimpleCssSymbol(c)) break;
        }
        return offset;
    }

    private static boolean isSimpleCssSymbol(char c) {
        return c == '-' || Character.isJavaIdentifierPart(c);
    }

    public static boolean isLiteralInCssContext(PsiElement host, boolean allowClassSelectors) {
        PsiElement parent = host.getParent();
        JSReferenceExpression invokedMethod = JSUtils.getMethodNameIfInsideCall(parent);
        if (invokedMethod != null) {
            JSExpression invokedMethodQualifier;
            JSReferenceExpression chaining;
            String methodName = invokedMethod.getReferencedName();
            if (invokedMethod.getQualifier() == null && JavaScriptReferenceContributor.isJQuery(methodName) && parent.getNode().findChildByType(JSElementTypes.EXPRESSIONS, host.getNode().getTreeNext()) == null) {
                return true;
            }
            if (ourJQueryMethodsWithSelectors.contains((Object)methodName) || allowClassSelectors && ourJQueryMethodsWithClassNames.contains((Object)methodName) ? (chaining = JSUtils.findRefExprThatStartCallChaining(invokedMethod)) != null && chaining != invokedMethod && chaining.getQualifier() == null && JavaScriptReferenceContributor.isJQuery(chaining.getReferencedName()) : "query".equals(methodName) && (invokedMethodQualifier = invokedMethod.getQualifier()) instanceof JSReferenceExpression && "dojo".equals(((JSReferenceExpression)invokedMethodQualifier).getReferencedName()) && ((JSReferenceExpression)invokedMethodQualifier).getQualifier() == null) {
                return true;
            }
        }
        return false;
    }

    private static boolean isJQuery(String methodName) {
        return "$".equals(methodName) || "jQuery".equals(methodName);
    }
}

