/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.jest.JestRunConfiguration;
import com.intellij.javascript.jest.JestRunSettings;
import com.intellij.javascript.jest.scope.JestScopeKind;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JestUtil {
    public static final String PACKAGE_NAME = "jest";
    private static final String KEY__JEST_PACKAGE_DIR = "nodejs.jest.jest_package";
    private static final String TAG__CONFIG_FILE = "config-file";
    private static final String TAG__NODE_INTERPRETER = "node-interpreter";
    private static final String TAG__WORKING_DIR = "working-dir";
    private static final String TAG__JEST_OPTIONS = "jest-options";
    private static final String TAG__SCOPE_KIND = "scope-kind";
    private static final String TAG__TEST_FILE = "test-file";
    private static final String TAG__TEST_NAMES = "test-names";
    private static final String TAG__TEST_NAME = "test-name";

    private JestUtil() {
    }

    @NotNull
    public static JestRunSettings readXml(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/jest/JestUtil", "readXml"));
        }
        JestRunSettings.Builder builder = JestRunSettings.builder();
        builder.setConfigFilePath(JestUtil.readValue(element, TAG__CONFIG_FILE));
        String interpreterRefName = JDOMExternalizerUtil.getFirstChildValueAttribute((Element)element, (String)TAG__NODE_INTERPRETER);
        builder.setInterpreterRef(interpreterRefName == null ? NodeJsInterpreterRef.createProjectRef() : NodeJsInterpreterRef.create(interpreterRefName));
        builder.setWorkingDir(JestUtil.readValue(element, TAG__WORKING_DIR));
        builder.setJestOptions(JestUtil.readValue(element, TAG__JEST_OPTIONS));
        builder.setEnvData(EnvironmentVariablesData.readExternal((Element)element));
        JestScopeKind scopeKind = JestUtil.readScopeKind(element);
        builder.setScopeKind(scopeKind);
        if (scopeKind == JestScopeKind.TEST_FILE || scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            builder.setTestFilePath(JestUtil.readValue(element, TAG__TEST_FILE));
        }
        if (scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            builder.setTestNames(JestUtil.readTestNames(element));
        }
        JestRunSettings jestRunSettings = builder.build();
        if (jestRunSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestUtil", "readXml"));
        }
        return jestRunSettings;
    }

    @NotNull
    private static JestScopeKind readScopeKind(@NotNull Element element) {
        JestScopeKind jestScopeKind;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/jest/JestUtil", "readScopeKind"));
        }
        String scopeKindStr = JestUtil.readValue(element, TAG__SCOPE_KIND);
        try {
            jestScopeKind = JestScopeKind.valueOf(scopeKindStr);
        }
        catch (Exception ignored) {
            JestScopeKind jestScopeKind2 = JestScopeKind.ALL;
            if (jestScopeKind2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestUtil", "readScopeKind"));
            }
            return jestScopeKind2;
        }
        if (jestScopeKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestUtil", "readScopeKind"));
        }
        return jestScopeKind;
    }

    @NotNull
    private static String readValue(@NotNull Element element, @NotNull String key) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/jest/JestUtil", "readValue"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/javascript/jest/JestUtil", "readValue"));
        }
        String string = StringUtil.notNullize((String)JDOMExternalizerUtil.getFirstChildValueAttribute((Element)element, (String)key));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestUtil", "readValue"));
        }
        return string;
    }

    @NotNull
    private static List<String> readTestNames(@NotNull Element parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/javascript/jest/JestUtil", "readTestNames"));
        }
        Element testNamesElement = parent.getChild(TAG__TEST_NAMES);
        if (testNamesElement == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestUtil", "readTestNames"));
            }
            return list;
        }
        List list = JDOMExternalizerUtil.getChildrenValueAttributes((Element)testNamesElement, (String)TAG__TEST_NAME);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestUtil", "readTestNames"));
        }
        return list;
    }

    private static void writeValue(@NotNull Element element, @NotNull String tagName, @Nullable String value) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/jest/JestUtil", "writeValue"));
        }
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/intellij/javascript/jest/JestUtil", "writeValue"));
        }
        if (value != null) {
            JDOMExternalizerUtil.addElementWithValueAttribute((Element)element, (String)tagName, (String)value);
        }
    }

    public static void writeXml(@NotNull Element element, @NotNull JestRunSettings settings) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/jest/JestUtil", "writeXml"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/javascript/jest/JestUtil", "writeXml"));
        }
        if (!StringUtil.isEmptyOrSpaces((String)settings.getConfigFileSystemDependentPath())) {
            JestUtil.writeValue(element, TAG__CONFIG_FILE, FileUtil.toSystemIndependentName((String)settings.getConfigFileSystemDependentPath()));
        }
        JestUtil.writeValue(element, TAG__NODE_INTERPRETER, settings.getInterpreterRef().getReferenceName());
        JestUtil.writeValue(element, TAG__WORKING_DIR, FileUtil.toSystemIndependentName((String)settings.getWorkingDirSystemDependentPath()));
        if (StringUtil.isNotEmpty((String)settings.getJestOptions())) {
            JestUtil.writeValue(element, TAG__JEST_OPTIONS, settings.getJestOptions());
        }
        settings.getEnvData().writeExternal(element);
        JestScopeKind scopeKind = settings.getScopeKind();
        JestUtil.writeValue(element, TAG__SCOPE_KIND, scopeKind.name());
        if (scopeKind == JestScopeKind.TEST_FILE || scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            JestUtil.writeValue(element, TAG__TEST_FILE, FileUtil.toSystemIndependentName((String)settings.getTestFileSystemDependentPath()));
        }
        if (scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            Element testNamesElement = new Element(TAG__TEST_NAMES);
            if (!settings.getTestNames().isEmpty()) {
                JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)testNamesElement, (String)TAG__TEST_NAME, settings.getTestNames());
            }
            element.addContent(testNamesElement);
        }
    }

    @NotNull
    public static List<VirtualFile> listPossibleConfigFilesInProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/jest/JestUtil", "listPossibleConfigFilesInProject"));
        }
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestUtil", "listPossibleConfigFilesInProject"));
        }
        return list;
    }

    public static boolean isJestConfigFile(@NotNull CharSequence sequence) {
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/javascript/jest/JestUtil", "isJestConfigFile"));
        }
        return StringUtil.equals((CharSequence)"jest.conf.json", (CharSequence)sequence) || StringUtil.equals((CharSequence)"jest.config", (CharSequence)sequence);
    }

    @NotNull
    public static NodePackage getJestPackage(@NotNull Project project, @Nullable NodeJsInterpreter interpreter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/jest/JestUtil", "getJestPackage"));
        }
        String packagePath = JestUtil.getPackagePath(project);
        if (packagePath == null) {
            NodePackage defaultPackage = NodePackage.findPreferredPackage(project, PACKAGE_NAME, interpreter);
            JestUtil.setPackagePath(project, defaultPackage.getSystemIndependentPath());
            NodePackage nodePackage = defaultPackage;
            if (nodePackage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestUtil", "getJestPackage"));
            }
            return nodePackage;
        }
        NodePackage nodePackage = new NodePackage(StringUtil.notNullize((String)packagePath));
        if (nodePackage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestUtil", "getJestPackage"));
        }
        return nodePackage;
    }

    public static void setJestPackage(@NotNull Project project, @NotNull NodePackage jestPackage) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/jest/JestUtil", "setJestPackage"));
        }
        if (jestPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jestPackage", "com/intellij/javascript/jest/JestUtil", "setJestPackage"));
        }
        JestUtil.setPackagePath(project, jestPackage.getSystemIndependentPath());
    }

    private static void setPackagePath(@NotNull Project project, @NotNull String value) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/jest/JestUtil", "setPackagePath"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/javascript/jest/JestUtil", "setPackagePath"));
        }
        PropertiesComponent.getInstance((Project)project).setValue(KEY__JEST_PACKAGE_DIR, value);
    }

    @Nullable
    private static String getPackagePath(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/jest/JestUtil", "getPackagePath"));
        }
        return PropertiesComponent.getInstance((Project)project).getValue(KEY__JEST_PACKAGE_DIR);
    }

    @NotNull
    public static File getJestMainJsFile(@NotNull NodePackage jestPackage) {
        if (jestPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jestPackage", "com/intellij/javascript/jest/JestUtil", "getJestMainJsFile"));
        }
        File file = new File(jestPackage.getSystemDependentPath(), "bin/jest");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestUtil", "getJestMainJsFile"));
        }
        return file;
    }

    @NotNull
    public static String escapeJavaScriptRegex(@NotNull String str, @NotNull String escapeIgnoreChars) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/javascript/jest/JestUtil", "escapeJavaScriptRegex"));
        }
        if (escapeIgnoreChars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "escapeIgnoreChars", "com/intellij/javascript/jest/JestUtil", "escapeJavaScriptRegex"));
        }
        String charsToEscape = "\\.?*+^$[](){}|-";
        for (int i = 0; i < charsToEscape.length(); ++i) {
            char ch = charsToEscape.charAt(i);
            if (StringUtil.containsChar((String)escapeIgnoreChars, (char)ch)) continue;
            str = str.replace(String.valueOf(ch), "\\" + ch);
        }
        String string = str;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestUtil", "escapeJavaScriptRegex"));
        }
        return string;
    }

    public static void checkRunConfiguration(@NotNull JestRunConfiguration configuration) throws RuntimeConfigurationException {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/javascript/jest/JestUtil", "checkRunConfiguration"));
        }
        JestRunSettings settings = configuration.getRunSettings();
        if (!StringUtil.isEmptyOrSpaces((String)settings.getConfigFileSystemDependentPath())) {
            JestUtil.validatePath(false, "configuration file", settings.getConfigFileSystemDependentPath());
        }
        JestUtil.validatePath(true, "working directory", settings.getWorkingDirSystemDependentPath());
        NodeJsInterpreter interpreter = settings.getInterpreterRef().resolve(configuration.getProject());
        NodeJsLocalInterpreter.checkForRunConfiguration(interpreter);
        configuration.getJestPackage().validateForRunConfiguration(PACKAGE_NAME);
        JestUtil.validatePath(true, "working directory", settings.getWorkingDirSystemDependentPath());
        JestScopeKind scopeKind = settings.getScopeKind();
        if (scopeKind == JestScopeKind.TEST_FILE || scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            JestUtil.validatePath(false, "test file", settings.getTestFileSystemDependentPath());
            if (scopeKind == JestScopeKind.SUITE && settings.getTestNames().isEmpty()) {
                throw new RuntimeConfigurationError("Unspecified suite name");
            }
            if (scopeKind == JestScopeKind.TEST && settings.getTestNames().isEmpty()) {
                throw new RuntimeConfigurationError("Unspecified test name");
            }
        }
    }

    private static void validatePath(boolean shouldBeDirectory, @NotNull String pathLabelName, @Nullable String path) throws RuntimeConfigurationException {
        boolean exists;
        if (pathLabelName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathLabelName", "com/intellij/javascript/jest/JestUtil", "validatePath"));
        }
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            throw new RuntimeConfigurationError("Unspecified " + pathLabelName);
        }
        File file = new File(path);
        if (!file.isAbsolute()) {
            throw new RuntimeConfigurationError("No such " + pathLabelName);
        }
        boolean bl = exists = shouldBeDirectory ? file.isDirectory() : file.isFile();
        if (!exists) {
            throw new RuntimeConfigurationError("No such " + pathLabelName);
        }
    }
}

