/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.local;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.NodeSettings;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterDialog;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsLocalInterpreter
extends NodeJsInterpreter {
    private static final Logger LOG = Logger.getInstance(NodeJsLocalInterpreter.class);
    public static final String YARN_PACKAGE_NAME = "yarn";
    private static final String NPM_EXECUTABLE_NAME = SystemInfo.isWindows ? "npm.cmd" : "npm";
    static final String WIN_EXE_EXT = ".exe";
    private static final int BLOCKING_WAIT_TIMEOUT_MILLIS = 2000;
    private static final int TOTAL_WAIT_TIMEOUT_MILLIS = 30000;
    private static final String NPM_CLI_JS_RELATIVE_PATH = "bin" + File.separator + "npm-cli.js";
    private final String myInterpreterSystemIndependentPath;
    private final String myInterpreterSystemDependentPath;
    private final File myInterpreter;
    private volatile String myNpmPackageDir;
    private volatile boolean myNpmDetected;
    private volatile NodeSettings mySettings;
    private FutureTask<String> myConfigPrefixFuture;
    private final Object myConfigPrefixFutureLock;

    public NodeJsLocalInterpreter(@NotNull String interpreterPath, @Nullable String npmPackageDir) {
        if (interpreterPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterPath", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "<init>"));
        }
        this.myNpmDetected = false;
        this.myConfigPrefixFutureLock = new Object();
        this.myInterpreterSystemIndependentPath = FileUtil.toSystemIndependentName((String)interpreterPath);
        this.myInterpreterSystemDependentPath = FileUtil.toSystemDependentName((String)interpreterPath);
        this.myInterpreter = new File(interpreterPath);
        if (!StringUtil.isEmptyOrSpaces((String)npmPackageDir)) {
            this.myNpmPackageDir = FileUtil.toSystemDependentName((String)npmPackageDir);
        }
    }

    @Override
    @NotNull
    public String getReferenceName() {
        String path = this.myInterpreterSystemIndependentPath;
        if (SystemInfo.isWindows && path.endsWith(WIN_EXE_EXT)) {
            path = path.substring(0, path.length() - WIN_EXE_EXT.length());
        }
        String string = path;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getReferenceName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String userHome = FileUtil.toSystemDependentName((String)SystemProperties.getUserHome());
        if (StringUtil.isEmptyOrSpaces((String)userHome)) {
            String string = this.myInterpreterSystemDependentPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getPresentableName"));
            }
            return string;
        }
        String userHomeWithSeparator = (userHome = StringUtil.trimEnd((String)userHome, (char)File.separatorChar)) + File.separatorChar;
        if (this.myInterpreterSystemDependentPath.startsWith(userHomeWithSeparator)) {
            String string = "~" + this.myInterpreterSystemDependentPath.substring(userHome.length());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getPresentableName"));
            }
            return string;
        }
        String string = this.myInterpreterSystemDependentPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getPresentableName"));
        }
        return string;
    }

    @Override
    @Nullable
    public Ref<SemVer> getCachedVersion() {
        return NodeJsLocalInterpreterManager.getInstance().getCachedVersion(this);
    }

    @Override
    public void fetchVersion(@NotNull NullableConsumer<SemVer> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "fetchVersion"));
        }
        NodeJsLocalInterpreterManager.getInstance().fetchVersion(this, consumer);
    }

    @Override
    @Nullable
    public String validate(@Nullable Project project) {
        return this.isValid() ? null : "Please specify Node.js interpreter correctly";
    }

    @NotNull
    public String getInterpreterSystemDependentPath() {
        String string = this.myInterpreterSystemDependentPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getInterpreterSystemDependentPath"));
        }
        return string;
    }

    @NotNull
    public String getInterpreterSystemIndependentPath() {
        String string = this.myInterpreterSystemIndependentPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getInterpreterSystemIndependentPath"));
        }
        return string;
    }

    public boolean isValid() {
        return this.myInterpreter.isFile() && this.myInterpreter.canExecute();
    }

    @NotNull
    public NodeJsLocalInterpreterType getType() {
        NodeJsLocalInterpreterType nodeJsLocalInterpreterType = NodeJsLocalInterpreterType.getInstance();
        if (nodeJsLocalInterpreterType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getType"));
        }
        return nodeJsLocalInterpreterType;
    }

    @Override
    public boolean deepEquals(@Nullable NodeJsInterpreter other) {
        return this.equals(other) && ComparatorUtil.equalsNullable((Object)this.myNpmPackageDir, (Object)((NodeJsLocalInterpreter)other).myNpmPackageDir);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeJsLocalInterpreter that = (NodeJsLocalInterpreter)o;
        return this.myInterpreterSystemIndependentPath.equals(that.myInterpreterSystemIndependentPath);
    }

    public int hashCode() {
        return this.myInterpreterSystemIndependentPath.hashCode();
    }

    public String toString() {
        return this.myInterpreterSystemIndependentPath;
    }

    @NotNull
    public String getNpmPackageDir() {
        String npmPackageDirPath = this.myNpmPackageDir;
        if (npmPackageDirPath != null) {
            String string = npmPackageDirPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getNpmPackageDir"));
            }
            return string;
        }
        File npmPackageDir = this.detectNpmPackageDir();
        this.myNpmPackageDir = npmPackageDirPath = npmPackageDir != null ? npmPackageDir.getAbsolutePath() : "";
        this.myNpmDetected = true;
        String string = npmPackageDirPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getNpmPackageDir"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNpmPackageDir(@NotNull String npmPackageDir) {
        if (npmPackageDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "npmPackageDir", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "setNpmPackageDir"));
        }
        this.myNpmPackageDir = npmPackageDir;
        this.myNpmDetected = false;
        Object object = this.myConfigPrefixFutureLock;
        synchronized (object) {
            this.myConfigPrefixFuture = null;
        }
    }

    @NotNull
    public String getNpmPackageDirNoDetection() {
        String string = StringUtil.notNullize((String)this.myNpmPackageDir);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getNpmPackageDirNoDetection"));
        }
        return string;
    }

    @Nullable
    private File detectNpmPackageDir() {
        File npmExecutable;
        File binDir;
        if (this.myInterpreter.isFile() && (binDir = this.myInterpreter.getParentFile()) != null) {
            File npmPackageDir = NodeJsLocalInterpreter.guessNpmPackageDirByNpmBinDir(binDir);
            if (npmPackageDir != null) {
                return npmPackageDir;
            }
            npmPackageDir = this.guessNpmPackageDirForNodist(binDir);
            if (npmPackageDir != null) {
                return npmPackageDir;
            }
            if (this.myInterpreterSystemIndependentPath.contains("/Cellar/") && (npmPackageDir = new File(binDir, "libexec/npm")).isDirectory()) {
                return npmPackageDir;
            }
        }
        if ((npmExecutable = PathEnvironmentVariableUtil.findInPath((String)NPM_EXECUTABLE_NAME, null)) != null) {
            return NodeJsLocalInterpreter.guessNpmPackageDirByNpmBinDir(npmExecutable.getParentFile());
        }
        return null;
    }

    @Nullable
    private File guessNpmPackageDirForNodist(@NotNull File binDir) {
        String nodistPrefix;
        if (binDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binDir", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "guessNpmPackageDirForNodist"));
        }
        if (SystemInfo.isWindows && (nodistPrefix = EnvironmentUtil.getValue((String)"NODIST_PREFIX")) != null) {
            nodistPrefix = FileUtil.toSystemIndependentName((String)nodistPrefix);
            if (this.myInterpreterSystemIndependentPath.startsWith(nodistPrefix = StringUtil.trimEnd((String)nodistPrefix, (String)"/") + "/")) {
                File nodistNpmFile;
                File parentDir2;
                File parentDir1 = binDir.getParentFile();
                File file = parentDir2 = parentDir1 != null ? parentDir1.getParentFile() : null;
                if (parentDir2 != null && (nodistNpmFile = new File(parentDir2, "bin\\npm.cmd")).isFile() && nodistNpmFile.canExecute()) {
                    return NodeJsLocalInterpreter.guessNpmPackageDirByNpmBinDir(nodistNpmFile.getParentFile());
                }
            }
        }
        return null;
    }

    @Nullable
    public VirtualFile getGlobalNodeModulesVirtualDir() {
        File globalNodeModulesDir;
        String configPrefix = this.fetchConfigPrefix();
        if (StringUtil.isNotEmpty((String)configPrefix) && (globalNodeModulesDir = SystemInfo.isWindows ? new File(configPrefix, "node_modules") : new File(configPrefix, "lib/node_modules")).isDirectory()) {
            VirtualFile file = LocalFileSystem.getInstance().findFileByIoFile(globalNodeModulesDir);
            if (file == null) {
                TransactionGuard.submitTransaction((Disposable)ApplicationManager.getApplication(), () -> WriteAction.run(() -> {
                    VirtualFile result = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(globalNodeModulesDir);
                    LOG.info("Npm config prefix (" + globalNodeModulesDir + ") refresh: " + (result != null ? "success" : "not found"));
                }));
            }
            return file;
        }
        NodeSettings settings = this.mySettings;
        if (settings == null) {
            this.mySettings = settings = new NodeSettings(this.myInterpreterSystemDependentPath);
        }
        return settings.getGlobalNodeModulesVirtualDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String fetchConfigPrefix() {
        FutureTask<String> future;
        Object object = this.myConfigPrefixFutureLock;
        synchronized (object) {
            future = this.myConfigPrefixFuture;
            if (future == null) {
                future = new FutureTask<String>(() -> {
                    try {
                        return this.doFetchConfigPrefix();
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to run 'npm config get prefix'", (Throwable)e);
                        return null;
                    }
                });
                ApplicationManager.getApplication().executeOnPooledThread(future);
                this.myConfigPrefixFuture = future;
            }
        }
        try {
            return future.get(2000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted npm global package dir calculation", (Throwable)e);
        }
        catch (ExecutionException e) {
        }
        catch (TimeoutException e) {
            LOG.warn("Npm global package dir hasn't been calculated in 2000 ms, making a guess");
        }
        return null;
    }

    @NotNull
    private String doFetchConfigPrefix() throws com.intellij.execution.ExecutionException {
        String errorMessage = this.validate(null);
        if (errorMessage != null) {
            throw new com.intellij.execution.ExecutionException(errorMessage);
        }
        long startNano = System.nanoTime();
        String npmCliJsFilePath = this.getValidNpmCliJsFilePathOrDetect();
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{this.myInterpreterSystemDependentPath, npmCliJsFilePath, "config", "get", "prefix"});
        commandLine.setCharset(StandardCharsets.UTF_8);
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        CapturingProcessHandler processHandler = new CapturingProcessHandler(commandLine);
        ProcessOutput output = processHandler.runProcess(30000, true);
        if (output.isTimeout()) {
            throw new com.intellij.execution.ExecutionException("'" + commandLine.getCommandLineString() + "' command run is timed out (>" + 30000 + " ms)");
        }
        String dirName = output.getStdout().trim();
        LOG.info(commandLine.getCommandLineString() + "=" + dirName + " (" + TimeoutUtil.getDurationMillis((long)startNano) + " ms)");
        String string = FileUtil.expandUserHome((String)dirName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "doFetchConfigPrefix"));
        }
        return string;
    }

    @NotNull
    private String getValidNpmCliJsFilePathOrDetect() throws com.intellij.execution.ExecutionException {
        String string;
        try {
            string = this.getValidNpmCliJsFilePath();
        }
        catch (com.intellij.execution.ExecutionException e) {
            File npmCliJsFile;
            File npmPackageDir;
            if (!this.myNpmDetected && (npmPackageDir = this.detectNpmPackageDir()) != null && (npmCliJsFile = new File(npmPackageDir, NPM_CLI_JS_RELATIVE_PATH)).isFile()) {
                String string2 = npmCliJsFile.getAbsolutePath();
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getValidNpmCliJsFilePathOrDetect"));
                }
                return string2;
            }
            throw e;
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getValidNpmCliJsFilePathOrDetect"));
        }
        return string;
    }

    @Nullable
    private static File guessNpmPackageDirByNpmBinDir(@Nullable File npmBinDir) {
        if (npmBinDir == null) {
            return null;
        }
        File npmPackageDir = null;
        if (SystemInfo.isWindows) {
            npmPackageDir = new File(npmBinDir, "node_modules\\npm");
        } else {
            File parent = npmBinDir.getParentFile();
            if (parent != null) {
                npmPackageDir = new File(parent, "lib/node_modules/npm");
            }
        }
        return npmPackageDir != null && npmPackageDir.isDirectory() ? npmPackageDir : null;
    }

    @NotNull
    public String getValidNpmCliJsFilePath() throws com.intellij.execution.ExecutionException {
        String string = this.getValidNpmCliJsFilePath(null);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getValidNpmCliJsFilePath"));
        }
        return string;
    }

    public boolean isYarnAlikePackage() {
        String name = PathUtil.getFileName((String)this.getNpmPackageDir());
        return name.contains(YARN_PACKAGE_NAME) || SystemInfo.isWindows && name.contains("Yarn");
    }

    @NotNull
    public String getValidNpmCliJsFilePath(@Nullable Project project) throws com.intellij.execution.ExecutionException {
        String npmPackageDirPath = this.getNpmPackageDir();
        if (StringUtil.isEmpty((String)npmPackageDirPath)) {
            String string = this.invalidNpmPackage(project, "Please specify npm or yarn package");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getValidNpmCliJsFilePath"));
            }
            return string;
        }
        File npmPackageDir = new File(npmPackageDirPath);
        if (!npmPackageDir.isAbsolute() || !npmPackageDir.isDirectory()) {
            String string = this.invalidNpmPackage(project, "Please correct path to npm or yarn package: no such directory \"" + npmPackageDirPath + "\"");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getValidNpmCliJsFilePath"));
            }
            return string;
        }
        if (this.isYarnAlikePackage()) {
            String string = this.findValidFile(npmPackageDir, "bin" + File.separator + "yarn.js", project);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getValidNpmCliJsFilePath"));
            }
            return string;
        }
        String string = this.findValidFile(npmPackageDir, NPM_CLI_JS_RELATIVE_PATH, project);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "getValidNpmCliJsFilePath"));
        }
        return string;
    }

    @NotNull
    private String findValidFile(@NotNull File packageDir, @NotNull String relativePath, @Nullable Project project) throws com.intellij.execution.ExecutionException {
        if (packageDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageDir", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "findValidFile"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "findValidFile"));
        }
        File mainJsFile = new File(packageDir, relativePath);
        if (!mainJsFile.isFile()) {
            String string = this.invalidNpmPackage(project, "Please specify npm or yarn package: cannot find \"" + relativePath + "\" inside \"" + packageDir + "\" directory");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "findValidFile"));
            }
            return string;
        }
        String string = mainJsFile.getAbsolutePath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "findValidFile"));
        }
        return string;
    }

    private String invalidNpmPackage(@Nullable Project project, @NotNull String errorMessage) throws com.intellij.execution.ExecutionException {
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "invalidNpmPackage"));
        }
        if (project != null) {
            NodeJsLocalInterpreterDialog.edit(project, this);
            return this.getValidNpmCliJsFilePath(null);
        }
        throw new com.intellij.execution.ExecutionException(errorMessage);
    }

    public boolean isElectron() {
        return this.myInterpreterSystemIndependentPath.endsWith("/Contents/MacOS/Electron") || this.myInterpreterSystemIndependentPath.endsWith("/electron") || this.myInterpreterSystemIndependentPath.endsWith("/electron.cmd");
    }

    @Nullable
    public static NodeJsLocalInterpreter tryCast(@Nullable NodeJsInterpreter interpreter) {
        return (NodeJsLocalInterpreter)ObjectUtils.tryCast((Object)interpreter, NodeJsLocalInterpreter.class);
    }

    @NotNull
    public static NodeJsLocalInterpreter cast(@Nullable NodeJsInterpreter interpreter) throws com.intellij.execution.ExecutionException {
        if (interpreter == null) {
            throw new com.intellij.execution.ExecutionException("Please specify Node.js interpreter");
        }
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.tryCast(interpreter);
        if (localInterpreter == null) {
            throw new com.intellij.execution.ExecutionException("Please specify local Node.js interpreter");
        }
        NodeJsLocalInterpreter nodeJsLocalInterpreter = localInterpreter;
        if (nodeJsLocalInterpreter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "cast"));
        }
        return nodeJsLocalInterpreter;
    }

    @NotNull
    public static NodeJsLocalInterpreter castAndValidate(@Nullable NodeJsInterpreter interpreter) throws com.intellij.execution.ExecutionException {
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.cast(interpreter);
        if (localInterpreter.isValid()) {
            NodeJsLocalInterpreter nodeJsLocalInterpreter = localInterpreter;
            if (nodeJsLocalInterpreter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter", "castAndValidate"));
            }
            return nodeJsLocalInterpreter;
        }
        throw new com.intellij.execution.ExecutionException("Please specify Node.js interpreter correctly");
    }

    @Nullable
    public static String getErrorMessage(@Nullable NodeJsInterpreter interpreter) {
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.tryCast(interpreter);
        if (localInterpreter == null) {
            return "Please specify local Node.js interpreter";
        }
        return localInterpreter.validate(null);
    }

    public static void checkForRunConfiguration(@Nullable NodeJsInterpreter interpreter) throws RuntimeConfigurationError {
        String errorMessage = NodeJsLocalInterpreter.getErrorMessage(interpreter);
        if (errorMessage != null) {
            throw new RuntimeConfigurationError(errorMessage);
        }
    }
}

