/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.reference;

import com.intellij.javascript.JSFileReference;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class RequiredFileSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public RequiredFileSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer) {
        ResolvedModuleInfo info;
        VirtualFile dir;
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/javascript/nodejs/reference/RequiredFileSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/javascript/nodejs/reference/RequiredFileSearcher", "processQuery"));
        }
        PsiElement element = queryParameters.getElementToSearch();
        if (element instanceof PsiFile) {
            String fileName;
            VirtualFile file = ((PsiFile)element).getVirtualFile();
            if (file != null && (fileName = file.getName()).startsWith("index") && JSFileReference.findImplicitExtension(fileName) != null) {
                String parentName;
                VirtualFile parent = file.getParent();
                String string = parentName = parent != null ? parent.getName() : null;
                if (parentName != null) {
                    queryParameters.getOptimizer().searchWord(parentName, queryParameters.getEffectiveSearchScope(), true, element);
                }
            }
        } else if (element instanceof PsiDirectory && (dir = ((PsiDirectory)element).getVirtualFile()).isDirectory() && (info = NodeModuleDirectorySearchProcessor.PROCESSOR.loadDirectory(null, dir, ModuleType.EXACT_PATH, true)) != null) {
            VirtualFile file = info.getModuleMainFile();
            PsiFile psiFile = PsiManager.getInstance((Project)queryParameters.getProject()).findFile(file);
            if (psiFile != null) {
                queryParameters.getOptimizer().searchWord(dir.getName(), queryParameters.getEffectiveSearchScope(), true, (PsiElement)psiFile);
            }
        }
    }
}

