/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css.linter.stylelint;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.lang.css.linter.stylelint.StylelintState;
import com.intellij.lang.javascript.linter.JSLinterBaseView;
import com.intellij.openapi.project.Project;
import com.intellij.psi.css.CssBundle;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StylelintView
extends JSLinterBaseView<StylelintState> {
    private final NodeJsInterpreterField myNodeInterpreterField;
    private final NodePackageField myStylelintPackageField;
    private final JPanel myCenterPanel;

    public StylelintView(@NotNull Project project, boolean fullModeDialog) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/css/linter/stylelint/StylelintView", "<init>"));
        }
        super(fullModeDialog);
        this.myNodeInterpreterField = new NodeJsInterpreterField(project, false);
        this.myStylelintPackageField = new NodePackageField(project, "stylelint", () -> this.myNodeInterpreterField.getInterpreter());
        JPanel panel = FormBuilder.createFormBuilder().setAlignLabelOnRight(true).setHorizontalGap(10).setVerticalGap(4).setFormLeftIndent(10).addLabeledComponent(CssBundle.message((String)"css.stylelint.view.node.path.label", (Object[])new Object[0]), (JComponent)((Object)this.myNodeInterpreterField)).addLabeledComponent(CssBundle.message((String)"css.stylelint.view.stylelintPackage.label", (Object[])new Object[0]), (JComponent)((Object)this.myStylelintPackageField)).getPanel();
        this.myCenterPanel = SwingHelper.wrapWithHorizontalStretch((JComponent)panel);
        this.myCenterPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
    }

    @Override
    @Nullable
    protected Component createTopRightComponent() {
        return null;
    }

    @Override
    @NotNull
    protected Component createCenterComponent() {
        JPanel jPanel = this.myCenterPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/css/linter/stylelint/StylelintView", "createCenterComponent"));
        }
        return jPanel;
    }

    @Override
    protected void handleEnableStatusChanged(boolean enabled) {
    }

    @Override
    @NotNull
    protected StylelintState getState() {
        StylelintState stylelintState = new StylelintState(this.myNodeInterpreterField.getInterpreterRef(), this.myStylelintPackageField.getSelected());
        if (stylelintState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/css/linter/stylelint/StylelintView", "getState"));
        }
        return stylelintState;
    }

    @Override
    protected void setState(@NotNull StylelintState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/css/linter/stylelint/StylelintView", "setState"));
        }
        this.myNodeInterpreterField.setInterpreterRef(state.getInterpreterRef());
        this.myStylelintPackageField.setSelected(state.getStylelintPackage());
        if (this.isFullModeDialog()) {
            this.myNodeInterpreterField.setPreferredWidthToFitText();
            this.myStylelintPackageField.setPreferredWidthToFitText();
        }
    }
}

