/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportExportSpecifierBase;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportSpecifierImpl;
import com.intellij.lang.ecmascript6.psi.stubs.ES6ExportSpecifierStub;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptResolveHelper;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.validation.HighlightSeverityHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.ArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ExportSpecifierImpl
extends ES6ImportExportSpecifierBase<ES6ExportSpecifierStub>
implements ES6ExportSpecifier,
HighlightSeverityHolder {
    public ES6ExportSpecifierImpl(ASTNode node) {
        super(node);
    }

    public ES6ExportSpecifierImpl(ES6ExportSpecifierStub stub) {
        super(stub, (IStubElementType)ES6ElementTypes.EXPORT_SPECIFIER);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/ecmascript6/psi/impl/ES6ExportSpecifierImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/ecmascript6/psi/impl/ES6ExportSpecifierImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/ecmascript6/psi/impl/ES6ExportSpecifierImpl", "processDeclarations"));
        }
        if (this.getParent().getParent() != place || "default".equals(this.getReferenceName())) {
            ES6ExportSpecifierAlias alias = this.getAlias();
            if (alias != null) {
                return alias.processDeclarations(processor, state, lastParent, place);
            }
            return processor.execute((PsiElement)this, state);
        }
        return true;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/ecmascript6/psi/impl/ES6ExportSpecifierImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitES6ExportSpecifier((ES6ExportSpecifier)this);
        } else {
            super.accept(visitor);
        }
    }

    @Nullable
    public ES6ExportSpecifierAlias getAlias() {
        return (ES6ExportSpecifierAlias)this.getStubOrPsiChild((IStubElementType)ES6ElementTypes.EXPORT_SPECIFIER_ALIAS);
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        final PsiFile file = this.getContainingFile();
        ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)file.getProject()).resolveWithCaching((PsiPolyVariantReference)this, (ResolveCache.PolyVariantResolver)new ResolveCache.PolyVariantResolver<ES6ExportSpecifierImpl>(){

            @NotNull
            public ResolveResult[] resolve(@NotNull ES6ExportSpecifierImpl specifier, boolean incompleteCode) {
                boolean hasFromPart;
                if (specifier == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "com/intellij/lang/ecmascript6/psi/impl/ES6ExportSpecifierImpl$1", "resolve"));
                }
                boolean bl = hasFromPart = ES6ExportSpecifierImpl.this.getDeclarationFromClause() != null;
                if (hasFromPart && ES6ExportSpecifierImpl.this.isDefault()) {
                    ResolveResult[] resolveResultArray = ES6ImportExportSpecifierBase.resolveDefaultExport(ES6ExportSpecifierImpl.this);
                    if (resolveResultArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ExportSpecifierImpl$1", "resolve"));
                    }
                    return resolveResultArray;
                }
                ES6ExportSpecifierImpl place = ES6ExportSpecifierImpl.this;
                String name = place.getReferenceName();
                ResolveResultSink sink = new ResolveResultSink((PsiElement)place, name, true);
                List<JSType> innerAliases = ES6PsiUtil.processSpecifier(ES6ExportSpecifierImpl.this, sink);
                ResolveResult[] results = sink.getResultsAsResolveResults();
                if (!hasFromPart && results.length == 0) {
                    QualifiedItemProcessor<?> processor = ES6PsiUtil.createSpecifierResolveProcessor(place, (PsiElement)place, sink);
                    TypeScriptResolveHelper.processGlobalThings(processor, ResolveState.initial(), (PsiElement)file);
                    results = sink.getResultsAsResolveResults();
                }
                if (results.length == 0 && !innerAliases.isEmpty()) {
                    ResolveResult[] resolveResultArray = ES6ImportSpecifierImpl.resolveWithInnerAliases(specifier, innerAliases);
                    if (resolveResultArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ExportSpecifierImpl$1", "resolve"));
                    }
                    return resolveResultArray;
                }
                if (results == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ExportSpecifierImpl$1", "resolve"));
                }
                return results;
            }
        }, true, incompleteCode);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ExportSpecifierImpl", "multiResolve"));
        }
        return resolveResultArray;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ExportSpecifierImpl", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Override
    @NotNull
    public HighlightSeverity getUnresolvedReferenceSeverity() {
        ES6FromClause fromClause;
        PsiElement parent = this.getParent();
        if (parent instanceof ES6ImportExportDeclaration && (fromClause = ((ES6ImportExportDeclaration)parent).getFromClause()) == null) {
            HighlightSeverity highlightSeverity = HighlightSeverity.ERROR;
            if (highlightSeverity == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ExportSpecifierImpl", "getUnresolvedReferenceSeverity"));
            }
            return highlightSeverity;
        }
        HighlightSeverity highlightSeverity = super.getUnresolvedReferenceSeverity();
        if (highlightSeverity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6ExportSpecifierImpl", "getUnresolvedReferenceSeverity"));
        }
        return highlightSeverity;
    }
}

