/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.actionscript.ActionScriptElementTypes;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.types.ES6FunctionPropertyElementType;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSEqualElementType;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.nashorn.NashornJSElementTypes;
import com.intellij.lang.javascript.types.JSCaseClauseElementType;
import com.intellij.lang.javascript.types.JSClassElementTypeBase;
import com.intellij.lang.javascript.types.JSCompositeBlockStatementElementType;
import com.intellij.lang.javascript.types.JSParameterElementType;
import com.intellij.lang.javascript.types.JSPropertyElementType;
import com.intellij.lang.javascript.types.JSVariableElementType;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.stubs.StubElementTypeHolderEP;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class JSExtendedLanguagesTokenSetProvider {
    private static final Logger LOG = Logger.getInstance((String)JSExtendedLanguagesTokenSetProvider.class.getName());
    public static final TokenSet OUR_STUBBED_FILTER;
    public static final TokenSet BLOCK_STATEMENTS;
    public static final TokenSet STATEMENTS;
    public static final TokenSet CLASSES;
    public static final TokenSet SOURCE_ELEMENTS;
    public static final TokenSet SCOPE_ELEMENTS;
    public static final TokenSet ASSIGNMENT_OPERATIONS;
    public static final TokenSet BINARY_OPERATIONS_WITH_DEFS;
    public static final TokenSet OPERATIONS;
    public static final TokenSet CASE_CLAUSES;
    public static final TokenSet PROPERTIES;
    public static final TokenSet PARAMETERS;
    public static final TokenSet VARIABLES;
    public static final TokenSet EQUAL_SIGNS;
    public static final TokenSet ARGUMENT_LISTS;
    public static final TokenSet EMBEDDED_CONTENTS;
    public static final TokenSet INITIALIZER_OWNERS;

    private JSExtendedLanguagesTokenSetProvider() {
    }

    private static TokenSet getPropertyTokenSet() {
        return TokenSet.create((IElementType[])IElementType.enumerate((IElementType.Predicate)new IElementType.Predicate(){

            public boolean matches(@NotNull IElementType type) {
                if (type == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/JSExtendedLanguagesTokenSetProvider$1", "matches"));
                }
                return type instanceof JSPropertyElementType || type instanceof ES6FunctionPropertyElementType;
            }
        }));
    }

    static TokenSet getClassTokenSet() {
        return TokenSet.create((IElementType[])IElementType.enumerate((IElementType.Predicate)new IElementType.Predicate(){

            public boolean matches(@NotNull IElementType type) {
                if (type == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/JSExtendedLanguagesTokenSetProvider$2", "matches"));
                }
                return type instanceof JSClassElementTypeBase || type == JSStubElementTypes.TYPESCRIPT_INTERFACE || type == JSStubElementTypes.TYPESCRIPT_ENUM;
            }
        }));
    }

    static TokenSet getCaseClauseTokenSet() {
        return TokenSet.create((IElementType[])IElementType.enumerate((IElementType.Predicate)new IElementType.Predicate(){

            public boolean matches(@NotNull IElementType type) {
                if (type == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/JSExtendedLanguagesTokenSetProvider$3", "matches"));
                }
                return type instanceof JSCaseClauseElementType;
            }
        }));
    }

    static TokenSet getParametersTokenSet() {
        return TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])IElementType.enumerate((IElementType.Predicate)new IElementType.Predicate(){

            public boolean matches(@NotNull IElementType type) {
                if (type == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/JSExtendedLanguagesTokenSetProvider$4", "matches"));
                }
                return type instanceof JSParameterElementType;
            }
        })), TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.DESTRUCTURING_PARAMETER})});
    }

    static TokenSet getVariablesTokenSet() {
        TokenSet extendedVariables = TokenSet.create((IElementType[])IElementType.enumerate((IElementType.Predicate)new IElementType.Predicate(){

            public boolean matches(@NotNull IElementType type) {
                if (type == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/JSExtendedLanguagesTokenSetProvider$5", "matches"));
                }
                return type instanceof JSVariableElementType;
            }
        }));
        return TokenSet.orSet((TokenSet[])new TokenSet[]{extendedVariables, JSElementTypes.BODY_VARIABLES, PARAMETERS});
    }

    static TokenSet getEqualSignTokenSet() {
        return TokenSet.create((IElementType[])IElementType.enumerate((IElementType.Predicate)new IElementType.Predicate(){

            public boolean matches(@NotNull IElementType type) {
                if (type == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/JSExtendedLanguagesTokenSetProvider$6", "matches"));
                }
                return type instanceof JSEqualElementType;
            }
        }));
    }

    static TokenSet getArgumentListTokenSet() {
        return TokenSet.create((IElementType[])new IElementType[]{JSElementTypes.ARGUMENT_LIST, JSElementTypes.E4X_FILTER_QUERY_ARGUMENT_LIST, NashornJSElementTypes.ARGUMENT_LIST});
    }

    static TokenSet getBlockStatementsTokenSet() {
        TokenSet enumerated = TokenSet.create((IElementType[])IElementType.enumerate((IElementType.Predicate)new IElementType.Predicate(){

            public boolean matches(@NotNull IElementType type) {
                if (type == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/JSExtendedLanguagesTokenSetProvider$7", "matches"));
                }
                return type instanceof JSCompositeBlockStatementElementType;
            }
        }));
        return TokenSet.orSet((TokenSet[])new TokenSet[]{enumerated, TokenSet.create((IElementType[])new IElementType[]{JSElementTypes.BLOCK_STATEMENT})});
    }

    private static TokenSet getStatementsTokenSet() {
        return TokenSet.orSet((TokenSet[])new TokenSet[]{BLOCK_STATEMENTS, TokenSet.create((IElementType[])new IElementType[]{JSElementTypes.LABELED_STATEMENT, JSElementTypes.EMPTY_STATEMENT, JSElementTypes.IF_STATEMENT, JSElementTypes.CONTINUE_STATEMENT, JSElementTypes.BREAK_STATEMENT, JSElementTypes.WITH_STATEMENT, JSStubElementTypes.RETURN_STATEMENT, JSElementTypes.THROW_STATEMENT, JSElementTypes.TRY_STATEMENT, JSElementTypes.SWITCH_STATEMENT, JSElementTypes.FOR_IN_STATEMENT, JSElementTypes.FOR_STATEMENT, JSElementTypes.WHILE_STATEMENT, JSElementTypes.DOWHILE_STATEMENT, JSElementTypes.EXPRESSION_STATEMENT, JSElementTypes.LET_STATEMENT, JSStubElementTypes.IMPORT_STATEMENT, JSStubElementTypes.PACKAGE_STATEMENT, JSStubElementTypes.USE_NAMESPACE_DIRECTIVE, TypeScriptElementTypes.IMPORT_STATEMENT}), JSElementTypes.VAR_STATEMENTS});
    }

    static {
        try {
            if (Extensions.getRootArea().hasExtensionPoint(StubElementTypeHolderEP.EP_NAME.getName())) {
                for (StubElementTypeHolderEP extension : (StubElementTypeHolderEP[])StubElementTypeHolderEP.EP_NAME.getExtensions()) {
                    extension.initialize();
                }
            } else if (!ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error("Class " + JSExtendedLanguagesTokenSetProvider.class.getName() + " initialized before the extension point required for working", (Throwable)new Exception());
            }
        }
        catch (Throwable t) {
            LOG.error("Exception in initializer of " + JSExtendedLanguagesTokenSetProvider.class.getName(), t);
        }
        OUR_STUBBED_FILTER = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.CLASS, ActionScriptElementTypes.FUNCTION_DECLARATION, JSStubElementTypes.ATTRIBUTE_LIST, JSStubElementTypes.INCLUDE_DIRECTIVE, JSStubElementTypes.ATTRIBUTE, JSStubElementTypes.PACKAGE_STATEMENT}), JSExtendedLanguagesTokenSetProvider.getClassTokenSet(), JSElementTypes.VAR_STATEMENTS});
        BLOCK_STATEMENTS = JSExtendedLanguagesTokenSetProvider.getBlockStatementsTokenSet();
        STATEMENTS = JSExtendedLanguagesTokenSetProvider.getStatementsTokenSet();
        CLASSES = JSExtendedLanguagesTokenSetProvider.getClassTokenSet();
        SOURCE_ELEMENTS = TokenSet.orSet((TokenSet[])new TokenSet[]{STATEMENTS, JSElementTypes.FUNCTION_DECLARATIONS, CLASSES, TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.NAMESPACE_DECLARATION, JSStubElementTypes.INCLUDE_DIRECTIVE, JSStubElementTypes.USE_NAMESPACE_DIRECTIVE, JSStubElementTypes.TYPESCRIPT_MODULE, TypeScriptElementTypes.IMPLICIT_MODULE, ES6ElementTypes.EXPORT_DECLARATION, ES6ElementTypes.IMPORT_DECLARATION, ES6ElementTypes.EXPORT_DEFAULT_ASSIGNMENT, TypeScriptElementTypes.EXPORT_ASSIGNMENT, JSStubElementTypes.TYPESCRIPT_TYPE_ALIAS})});
        SCOPE_ELEMENTS = TokenSet.orSet((TokenSet[])new TokenSet[]{JSElementTypes.FUNCTION_DECLARATIONS, JSElementTypes.FUNCTION_EXPRESSIONS, CLASSES, TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.TYPESCRIPT_MODULE, TypeScriptElementTypes.IMPLICIT_MODULE, JSElementTypes.CATCH_BLOCK})});
        ASSIGNMENT_OPERATIONS = TokenSet.orSet((TokenSet[])new TokenSet[]{JSTokenTypes.ASSIGNMENT_OPERATIONS, JSExtendedLanguagesTokenSetProvider.getEqualSignTokenSet()});
        BINARY_OPERATIONS_WITH_DEFS = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.COMMA, JSTokenTypes.EQ}), JSExtendedLanguagesTokenSetProvider.getEqualSignTokenSet()});
        OPERATIONS = TokenSet.orSet((TokenSet[])new TokenSet[]{JSTokenTypes.OPERATIONS, JSExtendedLanguagesTokenSetProvider.getEqualSignTokenSet()});
        CASE_CLAUSES = JSExtendedLanguagesTokenSetProvider.getCaseClauseTokenSet();
        PROPERTIES = JSExtendedLanguagesTokenSetProvider.getPropertyTokenSet();
        PARAMETERS = JSExtendedLanguagesTokenSetProvider.getParametersTokenSet();
        VARIABLES = JSExtendedLanguagesTokenSetProvider.getVariablesTokenSet();
        EQUAL_SIGNS = JSExtendedLanguagesTokenSetProvider.getEqualSignTokenSet();
        ARGUMENT_LISTS = JSExtendedLanguagesTokenSetProvider.getArgumentListTokenSet();
        EMBEDDED_CONTENTS = TokenSet.create((IElementType[])new IElementType[]{JSElementTypes.EMBEDDED_CONTENT, JSElementTypes.ES6_EMBEDDED_CONTENT, JSElementTypes.JSX_EMBEDDED_CONTENT, JSElementTypes.TS_EMBEDDED_CONTENT});
        INITIALIZER_OWNERS = TokenSet.orSet((TokenSet[])new TokenSet[]{VARIABLES, TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.DESTRUCTURING_ELEMENT, JSStubElementTypes.DESTRUCTURING_PARAMETER})});
    }
}

