/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.webcore.util.ProcessOutputCatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BowerCommandRun {
    private final ProcessOutputCatcher myCatcher;
    private final OSProcessHandler myProcessHandler;

    public BowerCommandRun(@NotNull OSProcessHandler processHandler) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/lang/javascript/bower/BowerCommandRun", "<init>"));
        }
        this.myCatcher = new ProcessOutputCatcher((BaseOSProcessHandler)processHandler);
        this.myProcessHandler = processHandler;
    }

    @NotNull
    public ProcessOutput captureOutput(@Nullable ProgressIndicator indicator, long timeoutMillis) throws ExecutionException {
        ProcessOutput output = this.myCatcher.run(indicator, timeoutMillis);
        if (output.isTimeout()) {
            throw new ExecutionException("Command '" + this.myProcessHandler.getCommandLine() + "' is timed out");
        }
        if (output.isCancelled()) {
            throw new ExecutionException("Command '" + this.myProcessHandler.getCommandLine() + "' is cancelled");
        }
        if (output.getExitCode() != 0) {
            throw new ExecutionException("Command '" + this.myProcessHandler.getCommandLine() + "' finished with exit code " + output.getExitCode() + ". Stdout:\n" + output.getStdout() + "\n\nstderr:\n" + output.getStderr());
        }
        ProcessOutput processOutput = output;
        if (processOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerCommandRun", "captureOutput"));
        }
        return processOutput;
    }

    public void terminate() {
        this.myCatcher.terminateAndWait();
    }
}

