/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskSet;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskTreeView;
import com.intellij.lang.javascript.buildTools.base.JsbtToolWindowManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JsbtService {
    public static final ExtensionPointName<JsbtService> EP_NAME = ExtensionPointName.create((String)"JavaScript.buildToolService");
    private static final Logger LOG = Logger.getInstance(JsbtService.class);
    private final Map<Project, JsbtToolWindowManager> myToolWindowManagerMap = ContainerUtil.newHashMap();

    @NotNull
    public abstract String getName();

    @NotNull
    public String getMenuItemDisplayName() {
        String string = this.getName() + " Tasks";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtService", "getMenuItemDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getSearchEverywhereDescription() {
        String string = this.getName() + " task";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtService", "getSearchEverywhereDescription"));
        }
        return string;
    }

    @NotNull
    public String getReloadTasksActionName() {
        if ("Reload tasks" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtService", "getReloadTasksActionName"));
        }
        return "Reload tasks";
    }

    @Nullable
    public abstract Icon getIcon();

    @NotNull
    public abstract JsbtFileManager getFileManager(@NotNull Project var1);

    @NotNull
    public final JsbtToolWindowManager getToolWindowManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtService", "getToolWindowManager"));
        }
        JsbtToolWindowManager toolWindowManager = this.myToolWindowManagerMap.get(project);
        if (toolWindowManager == null) {
            toolWindowManager = this.createToolWindowManager(project);
            this.myToolWindowManagerMap.put(project, toolWindowManager);
            ProjectManager.getInstance().addProjectManagerListener(project, (ProjectManagerListener)new ProjectManagerAdapter(){

                public void projectClosed(Project project) {
                    JsbtService.this.myToolWindowManagerMap.remove(project);
                    ProjectManager.getInstance().removeProjectManagerListener(project, (ProjectManagerListener)this);
                }
            });
        }
        JsbtToolWindowManager jsbtToolWindowManager = toolWindowManager;
        if (jsbtToolWindowManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtService", "getToolWindowManager"));
        }
        return jsbtToolWindowManager;
    }

    @NotNull
    protected abstract JsbtToolWindowManager createToolWindowManager(@NotNull Project var1);

    @NotNull
    public abstract JsbtTaskTreeView createTaskTreeView(@NotNull Project var1, @Nullable String var2);

    @NotNull
    public abstract List<VirtualFile> detectAllBuildfiles(@NotNull Project var1);

    @NotNull
    public List<VirtualFile> detectAllBuildfilesInContentRoots(@NotNull Project project, boolean webModulesOnly) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtService", "detectAllBuildfilesInContentRoots"));
        }
        List<VirtualFile> list = this.detectAllBuildfilesInContentRoots(project, webModulesOnly, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtService", "detectAllBuildfilesInContentRoots"));
        }
        return list;
    }

    @NotNull
    public abstract List<VirtualFile> detectAllBuildfilesInContentRoots(@NotNull Project var1, boolean var2, boolean var3);

    public abstract String getBuildfileCommonName();

    public abstract boolean isBuildfile(@NotNull VirtualFile var1);

    @NotNull
    public abstract JsbtFileStructure createEmptyFileStructure(@NotNull VirtualFile var1);

    @NotNull
    public abstract JsbtFileStructure fetchBuildfileStructure(@NotNull Project var1, @NotNull VirtualFile var2) throws JsbtTaskFetchException;

    @NotNull
    public abstract ConfigurationFactory getConfigurationFactory();

    public abstract boolean isConfigurationMatched(@NotNull RunConfiguration var1, @NotNull Object var2);

    public abstract void setupRunConfiguration(@NotNull RunConfiguration var1, @NotNull JsbtTaskSet var2);

    public abstract boolean showTaskListingSettingsDialog(@NotNull Project var1, @Nullable VirtualFile var2);

    @NotNull
    protected static <T extends JsbtService> AtomicNotNullLazyValue<T> newLazyInstance(final @NotNull Class<T> serviceClass) {
        if (serviceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceClass", "com/intellij/lang/javascript/buildTools/base/JsbtService", "newLazyInstance"));
        }
        AtomicNotNullLazyValue atomicNotNullLazyValue = new AtomicNotNullLazyValue<T>(){

            @NotNull
            protected T compute() {
                JsbtService instance = (JsbtService)EP_NAME.findExtension(serviceClass);
                if (instance == null) {
                    String message = "Cannot find extension " + EP_NAME.getName() + " of class " + serviceClass.getName();
                    LOG.error(message);
                    try {
                        instance = (JsbtService)serviceClass.newInstance();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Cannot instantiate new instance either: " + message, e);
                    }
                }
                JsbtService jsbtService = instance;
                if (jsbtService == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtService$2", "compute"));
                }
                return jsbtService;
            }
        };
        if (atomicNotNullLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtService", "newLazyInstance"));
        }
        return atomicNotNullLazyValue;
    }
}

