/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.annotations.NotNull;

public class FlowJSSettings {
    private final boolean isTypeCheckingEnabled;
    @NotNull
    private final String myFlowPath;
    private final boolean isOtherServicesEnabled;
    private final boolean isFlowResolveEnable;

    public FlowJSSettings(@NotNull Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/flow/FlowJSSettings", "<init>"));
        }
        this.isTypeCheckingEnabled = builder.isTypeCheckingEnabled;
        this.myFlowPath = FileUtil.toSystemIndependentName((String)builder.myFlowPath);
        this.isOtherServicesEnabled = builder.isOtherServicesEnabled;
        this.isFlowResolveEnable = builder.isFlowResolveEnable;
    }

    public Builder createBuilder() {
        return new Builder().setFlowExecutablePath(this.myFlowPath).setFlowResolveEnable(this.isFlowResolveEnable);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowJSSettings settings = (FlowJSSettings)o;
        if (!this.myFlowPath.equals(settings.myFlowPath)) {
            return false;
        }
        if (this.isTypeCheckingEnabled != settings.isTypeCheckingEnabled) {
            return false;
        }
        if (this.isOtherServicesEnabled != settings.isOtherServicesEnabled) {
            return false;
        }
        return this.isFlowResolveEnable == settings.isFlowResolveEnable;
    }

    public int hashCode() {
        int result = this.myFlowPath.hashCode();
        result = 31 * result + (this.isTypeCheckingEnabled ? 1 : 0);
        result = 31 * result + (this.isOtherServicesEnabled ? 1 : 0);
        result = 31 * result + (this.isFlowResolveEnable ? 1 : 0);
        return result;
    }

    public String toString() {
        return "FlowSettings{myFlowPath='" + this.myFlowPath + '\'' + '}';
    }

    public boolean isTypeCheckingEnabled() {
        return this.isTypeCheckingEnabled;
    }

    public boolean isOtherServicesEnabled() {
        return this.isOtherServicesEnabled;
    }

    @NotNull
    public String getFlowExecutablePath() {
        String string = this.myFlowPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSSettings", "getFlowExecutablePath"));
        }
        return string;
    }

    public boolean getFlowResolveEnable() {
        return this.isFlowResolveEnable;
    }

    public static class Builder {
        private String myFlowPath = "";
        private boolean isTypeCheckingEnabled = false;
        private boolean isFlowResolveEnable = false;
        private boolean isOtherServicesEnabled = false;

        @NotNull
        public Builder setFlowExecutablePath(@NotNull String flowPath) {
            if (flowPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flowPath", "com/intellij/lang/javascript/flow/FlowJSSettings$Builder", "setFlowExecutablePath"));
            }
            this.myFlowPath = flowPath;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSSettings$Builder", "setFlowExecutablePath"));
            }
            return builder;
        }

        @NotNull
        public Builder setFlowResolveEnable(boolean isFlowResolveEnable) {
            this.isFlowResolveEnable = isFlowResolveEnable;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSSettings$Builder", "setFlowResolveEnable"));
            }
            return builder;
        }

        @NotNull
        public Builder setTypeCheckingEnabled(boolean isEnabled) {
            this.isTypeCheckingEnabled = isEnabled;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSSettings$Builder", "setTypeCheckingEnabled"));
            }
            return builder;
        }

        @NotNull
        public Builder setOtherServicesEnabled(boolean isEnabled) {
            this.isOtherServicesEnabled = isEnabled;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSSettings$Builder", "setOtherServicesEnabled"));
            }
            return builder;
        }

        @NotNull
        public FlowJSSettings build() {
            FlowJSSettings flowJSSettings = new FlowJSSettings(this);
            if (flowJSSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/FlowJSSettings$Builder", "build"));
            }
            return flowJSSettings;
        }
    }
}

