/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter.blocks.alignment;

import com.intellij.formatting.Alignment;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.blocks.alignment.ASTNodeBasedAlignmentFactory;
import com.intellij.lang.javascript.formatter.blocks.alignment.LineCommentAlignmentFactory;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLocalAlignmentFactory
implements ASTNodeBasedAlignmentFactory {
    private final CommonCodeStyleSettings mySettings;
    private final Alignment myLocalAlignment;
    private final LineCommentAlignmentFactory myLineCommentAlignmentFactory;
    private ASTNodeBasedAlignmentFactory mySharedAlignmentFactory;

    public JSLocalAlignmentFactory(@NotNull CodeStyleSettings rootSettings, @NotNull Language dialect) {
        if (rootSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootSettings", "com/intellij/lang/javascript/formatter/blocks/alignment/JSLocalAlignmentFactory", "<init>"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/lang/javascript/formatter/blocks/alignment/JSLocalAlignmentFactory", "<init>"));
        }
        this(rootSettings.getCommonSettings(dialect));
    }

    public JSLocalAlignmentFactory(@NotNull CommonCodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/formatter/blocks/alignment/JSLocalAlignmentFactory", "<init>"));
        }
        this.mySettings = settings;
        CommonCodeStyleSettings.IndentOptions indentOptions = this.mySettings.getIndentOptions();
        assert (indentOptions != null);
        this.myLocalAlignment = Alignment.createAlignment();
        this.myLineCommentAlignmentFactory = new LineCommentAlignmentFactory(this.mySettings);
    }

    @Nullable
    protected Alignment getAlignment(@Nullable IElementType parentType, @Nullable IElementType childType) {
        if (parentType == JSElementTypes.FOR_STATEMENT && this.mySettings.ALIGN_MULTILINE_FOR && (JSElementTypes.EXPRESSIONS.contains(childType) || JSElementTypes.VAR_STATEMENTS.contains(childType))) {
            return this.myLocalAlignment;
        }
        if (JSElementTypes.PARAMETER_LISTS.contains(parentType) && this.mySettings.ALIGN_MULTILINE_PARAMETERS && (JSExtendedLanguagesTokenSetProvider.PARAMETERS.contains(childType) || JSTokenTypes.COMMENTS.contains(childType))) {
            return this.myLocalAlignment;
        }
        if (parentType == JSElementTypes.CONDITIONAL_EXPRESSION && this.mySettings.ALIGN_MULTILINE_TERNARY_OPERATION && JSElementTypes.EXPRESSIONS.contains(childType)) {
            return this.myLocalAlignment;
        }
        if (JSElementTypes.EXTENDS_IMPLEMENTS_LISTS.contains(parentType) && this.mySettings.ALIGN_MULTILINE_EXTENDS_LIST && JSStubElementTypes.EXTENDS_LIST_MEMBER == childType) {
            return this.myLocalAlignment;
        }
        if (parentType == JSElementTypes.PARENTHESIZED_EXPRESSION && this.mySettings.ALIGN_MULTILINE_PARENTHESIZED_EXPRESSION) {
            return this.myLocalAlignment;
        }
        if (parentType == JSElementTypes.ARRAY_LITERAL_EXPRESSION && this.mySettings.ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION && JSElementTypes.EXPRESSIONS.contains(childType)) {
            return this.myLocalAlignment;
        }
        return null;
    }

    public Alignment getLocalAlignment() {
        return this.myLocalAlignment;
    }

    @Override
    public Alignment getAlignment(@NotNull ASTNode child) {
        IElementType parentType;
        Alignment alignment;
        Alignment eolCommentAlignment;
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/lang/javascript/formatter/blocks/alignment/JSLocalAlignmentFactory", "getAlignment"));
        }
        IElementType childType = child.getElementType();
        if (childType == JSTokenTypes.END_OF_LINE_COMMENT && (eolCommentAlignment = this.myLineCommentAlignmentFactory.getAlignment(child)) != null) {
            return eolCommentAlignment;
        }
        ASTNode parent = child.getTreeParent();
        if (parent != null && (alignment = this.getAlignment(parentType = parent.getElementType(), childType)) != null) {
            return alignment;
        }
        if (this.mySharedAlignmentFactory != null) {
            return this.mySharedAlignmentFactory.getAlignment(child);
        }
        return null;
    }

    public void setSharedAlignmentFactory(ASTNodeBasedAlignmentFactory sharedAlignmentFactory) {
        this.mySharedAlignmentFactory = sharedAlignmentFactory;
    }

    public ASTNodeBasedAlignmentFactory getSharedAlignmentFactory() {
        return this.mySharedAlignmentFactory;
    }
}

