/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.amd;

import com.intellij.javascript.JSFileReference;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.javascript.nodejs.reference.NodeFileModulePsiReferenceBase;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.validation.HighlightSeverityHolder;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSModuleReference
extends JSFileReference
implements HighlightSeverityHolder {
    private static final String IOS = "ios";
    private static final String ANDROID = "android";
    public static final String DOT_IOS = ".ios";
    public static final String DOT_ANDROID = ".android";
    private final NotNullLazyValue<String[]> myExtensionsValue;
    private final String myNewFileTemplateName;
    private final boolean myIsSoft;

    public JSModuleReference(String text, int offset, @NotNull TextRange textRange, @NotNull FileReferenceSet fileReferenceSet, @Nullable String newFileTemplateName, boolean isSoft) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/lang/javascript/frameworks/amd/JSModuleReference", "<init>"));
        }
        if (fileReferenceSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileReferenceSet", "com/intellij/lang/javascript/frameworks/amd/JSModuleReference", "<init>"));
        }
        super(text, offset, textRange, fileReferenceSet);
        this.myExtensionsValue = new NotNullLazyValue<String[]>(){

            @NotNull
            protected String[] compute() {
                Object[] extensions = JSModuleReference.super.getImplicitExtensions();
                PsiElement element = JSModuleReference.this.getElement();
                String fileNameWithExtension = element.getContainingFile().getName();
                String extension = FileUtilRt.getExtension((String)fileNameWithExtension);
                if (StringUtil.isEmpty((String)extension)) {
                    if (extensions == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/JSModuleReference$1", "compute"));
                    }
                    return extensions;
                }
                String fileName = fileNameWithExtension.substring(0, fileNameWithExtension.length() - extension.length());
                String platform = FileUtilRt.getExtension((String)fileName);
                if (this.isReactPlatform(platform)) {
                    String[] stringArray = (String[])ArrayUtil.prepend((Object)this.getExtension(platform, extension), (Object[])extensions);
                    if (stringArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/JSModuleReference$1", "compute"));
                    }
                    return stringArray;
                }
                String[] stringArray = ArrayUtil.mergeArrays((String[])new String[]{this.getExtension(JSModuleReference.IOS, extension), this.getExtension(JSModuleReference.ANDROID, extension)}, (String[])extensions);
                if (stringArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/JSModuleReference$1", "compute"));
                }
                return stringArray;
            }

            private String getExtension(String platform, String extension) {
                return "." + platform + "." + extension;
            }

            private boolean isReactPlatform(@Nullable String platform) {
                return platform != null && (JSModuleReference.IOS.equalsIgnoreCase(platform) || JSModuleReference.ANDROID.equalsIgnoreCase(platform));
            }
        };
        this.myNewFileTemplateName = newFileTemplateName;
        this.myIsSoft = isSoft;
    }

    public String getNewFileTemplateName() {
        return this.myNewFileTemplateName != null ? this.myNewFileTemplateName : super.getNewFileTemplateName();
    }

    public boolean isSoft() {
        return this.myIsSoft;
    }

    @Override
    protected void innerResolveInContext(@NotNull String referenceText, @NotNull PsiFileSystemItem psiFileSystemItem, Collection<ResolveResult> resolveResults, boolean caseSensitive) {
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceText", "com/intellij/lang/javascript/frameworks/amd/JSModuleReference", "innerResolveInContext"));
        }
        if (psiFileSystemItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFileSystemItem", "com/intellij/lang/javascript/frameworks/amd/JSModuleReference", "innerResolveInContext"));
        }
        int size = resolveResults.size();
        super.innerResolveInContext(referenceText, psiFileSystemItem, resolveResults, caseSensitive);
        if (resolveResults.size() == size && psiFileSystemItem instanceof PsiDirectory && this.isLast()) {
            if (!psiFileSystemItem.isValid()) {
                return;
            }
            this.resolveElementsAsModule(psiFileSystemItem.getVirtualFile(), resolveResults);
            if (resolveResults.size() == 0 && this.isAcceptableEmptyReference(referenceText)) {
                this.simpleInnerResolveInContext(referenceText, psiFileSystemItem, resolveResults, caseSensitive);
            }
        }
    }

    private void resolveElementsAsModule(VirtualFile baseDir, Collection<ResolveResult> results) {
        PsiFile file;
        String lastPathComponent = this.getText();
        String path = this.getIndex() != 0 && lastPathComponent.isEmpty() ? "." : lastPathComponent;
        ResolvedModuleInfo moduleInfo = NodeModuleSearchUtil.resolveModuleByExactPath(baseDir, path);
        if (moduleInfo != null && (file = this.getElement().getManager().findFile(moduleInfo.getModuleMainFile())) != null) {
            results.add((ResolveResult)new PsiElementResolveResult((PsiElement)file));
        }
    }

    @Override
    protected String[] getImplicitExtensions() {
        return (String[])this.myExtensionsValue.getValue();
    }

    @Override
    protected boolean shouldStopImplicitExtensionProcessing(boolean sizeWasChanged, String currentExtension) {
        return super.shouldStopImplicitExtensionProcessing(sizeWasChanged, currentExtension) && !currentExtension.startsWith(DOT_IOS) && !currentExtension.startsWith(DOT_ANDROID);
    }

    protected Object createLookupItem(PsiElement candidate) {
        PsiDirectory directory;
        PsiDirectory parentDirectory;
        if (candidate instanceof PsiDirectory && (parentDirectory = (directory = (PsiDirectory)candidate).getParent()) != null && "node_modules".equals(parentDirectory.getName())) {
            VirtualFile context = PsiUtilCore.getVirtualFile((PsiElement)this.getElement());
            CompletionModuleInfo module = new CompletionModuleInfo(directory.getName(), directory.getVirtualFile(), ModuleType.NODE_MODULES_DIR);
            return NodeFileModulePsiReferenceBase.createLookupElement(context, module);
        }
        return JSCompletionUtil.createLookupElementForJSModule(candidate);
    }

    @Override
    @NotNull
    public HighlightSeverity getUnresolvedReferenceSeverity() {
        HighlightSeverity highlightSeverity = HighlightSeverity.WARNING;
        if (highlightSeverity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/JSModuleReference", "getUnresolvedReferenceSeverity"));
        }
        return highlightSeverity;
    }
}

