/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.mootools;

import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.literal.JSLiteralImplicitElementProvider;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MooToolsIndexingHandler
extends FrameworkIndexingHandler {
    private static final String[] INTERESTED_METHOD_NAMES = new String[]{"alias"};
    private static final String[] INTERESTED_PROPERTIES_NAMES = new String[]{"Extends", "Implements"};

    @Override
    public boolean processProperty(String name, @Nullable JSElement value, @NotNull JSElementIndexingData outData) {
        if (outData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outData", "com/intellij/lang/javascript/frameworks/mootools/MooToolsIndexingHandler", "processProperty"));
        }
        if (value instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpression((JSReferenceExpression)value)) {
            String fqn;
            JSNewExpression initializer = (JSNewExpression)PsiTreeUtil.getParentOfType((PsiElement)value, JSNewExpression.class);
            JSQualifiedNamedElement element = initializer != null ? JSPsiImplUtils.getInitializedElement((JSExpression)initializer) : null;
            String string = fqn = element != null ? element.getQualifiedName() : null;
            if (fqn != null) {
                outData.addBaseType(fqn, value.getText());
            }
        }
        return super.processProperty(name, value, outData);
    }

    @Override
    @NotNull
    public String[] interestedProperties() {
        if (INTERESTED_PROPERTIES_NAMES == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/mootools/MooToolsIndexingHandler", "interestedProperties"));
        }
        return INTERESTED_PROPERTIES_NAMES;
    }

    @Override
    @NotNull
    public String[] interestedMethodNames() {
        if (INTERESTED_METHOD_NAMES == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/mootools/MooToolsIndexingHandler", "interestedMethodNames"));
        }
        return INTERESTED_METHOD_NAMES;
    }

    @Override
    public JSLiteralImplicitElementProvider createLiteralImplicitElementProvider(@NotNull String calledMethodName) {
        if (calledMethodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calledMethodName", "com/intellij/lang/javascript/frameworks/mootools/MooToolsIndexingHandler", "createLiteralImplicitElementProvider"));
        }
        if ("alias".equals(calledMethodName)) {
            return new JSLiteralImplicitElementProvider(){

                @Override
                public void fillIndexingData(@NotNull JSLiteralExpression argument, @NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outIndexingData) {
                    JSExpression[] jsExpressions;
                    if (argument == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/intellij/lang/javascript/frameworks/mootools/MooToolsIndexingHandler$1", "fillIndexingData"));
                    }
                    if (callExpression == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/javascript/frameworks/mootools/MooToolsIndexingHandler$1", "fillIndexingData"));
                    }
                    if (outIndexingData == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outIndexingData", "com/intellij/lang/javascript/frameworks/mootools/MooToolsIndexingHandler$1", "fillIndexingData"));
                    }
                    JSExpression qualifier = ((JSReferenceExpression)callExpression.getMethodExpression()).getQualifier();
                    if (qualifier != null && (jsExpressions = callExpression.getArguments()).length == 2 && jsExpressions[0] instanceof JSLiteralExpression && jsExpressions[1] == argument) {
                        JSQualifiedNameImpl namespace;
                        JSQualifiedNameImpl jSQualifiedNameImpl = namespace = qualifier instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpression((JSReferenceExpression)qualifier) ? JSQualifiedNameImpl.fromQualifiedName(qualifier.getText()) : null;
                        if (namespace != null) {
                            outIndexingData.addImplicitElement((JSImplicitElement)new JSImplicitElementImpl(StringUtil.unquoteString((String)jsExpressions[1].getText()), namespace, (PsiElement)argument));
                        }
                    }
                }
            };
        }
        return super.createLiteralImplicitElementProvider(calledMethodName);
    }

    @Override
    public int getVersion() {
        return 2;
    }
}

