/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSXHarmonyLanguageDialect;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactFrameworkIndexingHandler
extends FrameworkIndexingHandler {
    public static final String REACT_COMPOSITE_COMPONENT = "ReactCompositeComponent";
    public static final String REACT_COMPONENT = "ReactComponent";
    public static final String PROPS = "props";

    @Override
    public void processCallExpression(JSCallExpression callExpression, @NotNull JSElementIndexingData outData) {
        if (outData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outData", "com/intellij/lang/javascript/frameworks/react/ReactFrameworkIndexingHandler", "processCallExpression"));
        }
        if (!JSXHarmonyLanguageDialect.isReactComponent((JSExpression)callExpression)) {
            return;
        }
        ReactFrameworkIndexingHandler.addClassFromVariable(callExpression, outData);
    }

    private static void addClassFromVariable(JSCallExpression callExpression, @NotNull JSElementIndexingData outData) {
        if (outData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outData", "com/intellij/lang/javascript/frameworks/react/ReactFrameworkIndexingHandler", "addClassFromVariable"));
        }
        JSQualifiedNamedElement variable = (JSQualifiedNamedElement)PsiTreeUtil.getParentOfType((PsiElement)callExpression, JSVariable.class);
        if (variable == null) {
            JSAssignmentExpression assignment = (JSAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)callExpression, JSAssignmentExpression.class);
            JSDefinitionExpression jSDefinitionExpression = variable = assignment != null ? assignment.getDefinitionExpression() : null;
        }
        if (variable != null) {
            String name = variable.getName();
            if (name == null) {
                return;
            }
            if (JSDocumentationUtils.isClassOrInterface(variable) == JSElementBase.ClassOrInterface.NONE) {
                JSImplicitElementImpl.Builder clazz = new JSImplicitElementImpl.Builder(name, (PsiElement)callExpression).setNamespace(variable.getNamespace()).setType(JSImplicitElement.Type.Class).setTypeString(REACT_COMPOSITE_COMPONENT);
                outData.addImplicitElement((JSImplicitElement)clazz.toImplicitElement());
            }
        }
    }

    @Override
    public void addContextNames(PsiElement context, List<String> names) {
        if (context == null) {
            return;
        }
        JSCallExpression call = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)context, JSCallExpression.class);
        if (call != null && JSXHarmonyLanguageDialect.isReactComponent((JSExpression)call)) {
            names.add(REACT_COMPONENT);
        }
        if (this.hasPropTypes(context)) {
            names.add(REACT_COMPONENT);
        }
    }

    @Override
    @Nullable
    public JSElementIndexingData processAnyProperty(@NotNull JSProperty property, @Nullable JSElementIndexingData outData) {
        JSQualifiedName parent;
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/javascript/frameworks/react/ReactFrameworkIndexingHandler", "processAnyProperty"));
        }
        JSQualifiedName namespace = property.getNamespace();
        String name = property.getName();
        if (namespace != null && "propTypes".equals(namespace.getName()) && name != null && (parent = namespace.getParent()) != null) {
            if (outData == null) {
                outData = new JSElementIndexingDataImpl();
            }
            JSQualifiedNameImpl props = JSQualifiedNameImpl.create(PROPS, parent);
            JSQualifiedNameImpl prop = JSQualifiedNameImpl.create(name, props);
            JSImplicitElementImpl.Builder propBuilder = new JSImplicitElementImpl.Builder(prop, (PsiElement)property).setContext(JSContext.INSTANCE).setType(JSImplicitElement.Type.Property).setTypeString(ReactFrameworkIndexingHandler.computeType(property.getValue())).setNamespaceExplicitlyDeclared(true);
            if (ReactFrameworkIndexingHandler.isRequired(property.getValue())) {
                propBuilder.setUserString("r");
            }
            outData.addImplicitElement((JSImplicitElement)propBuilder.toImplicitElement());
            PsiElement object = property.getParent();
            if (object instanceof JSObjectLiteralExpression && ((JSObjectLiteralExpression)object).getFirstProperty() == property) {
                JSImplicitElementImpl.Builder propsBuilder = new JSImplicitElementImpl.Builder(props, (PsiElement)property).setNamespace(parent).setTypeString(props.getQualifiedName()).setType(JSImplicitElement.Type.Property);
                outData.addImplicitElement((JSImplicitElement)propsBuilder.toImplicitElement());
            }
        }
        return outData;
    }

    @Override
    public boolean addTypeFromResolveResult(JSTypeEvaluator evaluator, PsiElement result, boolean hasSomeType) {
        if (result instanceof JSParameter && PROPS.equals(((JSParameter)result).getName()) && DialectDetector.isJSX(result)) {
            String qualifiedName;
            JSFunction function = ((JSParameter)result).getDeclaringFunction();
            String string = qualifiedName = function != null ? function.getQualifiedName() : null;
            if (ReactXmlExtension.isReactComponent((PsiElement)function, Collections.emptyList())) {
                JSTypeSource source = JSTypeSourceFactory.createTypeSource(result);
                JSType type = JSNamedType.createType(qualifiedName + "." + PROPS, source, JSContext.INSTANCE);
                evaluator.addType(type, result);
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static String computeType(JSExpression value) {
        if (value instanceof JSReferenceExpression) {
            String name = ((JSReferenceExpression)value).getReferenceName();
            if ("string".equals(name) || "object".equals(name) || "number".equals(name)) {
                return StringUtil.capitalize((String)name);
            }
            if ("bool".equals(name)) {
                return "Boolean";
            }
            if ("isRequired".equals(name)) {
                return ReactFrameworkIndexingHandler.computeType(((JSReferenceExpression)value).getQualifier());
            }
        }
        return null;
    }

    private static boolean isRequired(JSExpression value) {
        return value instanceof JSReferenceExpression && "isRequired".equals(((JSReferenceExpression)value).getReferenceName());
    }

    @Override
    public int getVersion() {
        return 7;
    }

    protected boolean hasPropTypes(PsiElement context) {
        JSClass clazz = DialectDetector.isES6(context) ? (JSClass)PsiTreeUtil.getParentOfType((PsiElement)context, JSClass.class) : null;
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(context);
        String name = clazz != null ? clazz.getQualifiedName() + ".propTypes" : null;
        List propTypes = name != null ? JSClassResolver.getInstance().findElementsByQNameIncludingImplicit(name, scope) : Collections.emptyList();
        return !propTypes.isEmpty();
    }

    static {
        JSImplicitElement.ourUserStringsRegistry.registerUserString("r");
    }
}

