/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.codeInsight.template.Template;
import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.generation.ActionScriptEventDispatchUtils;
import com.intellij.lang.javascript.generation.BaseJSGenerateHandler;
import com.intellij.lang.javascript.generation.BindablePropertiesForm;
import com.intellij.lang.javascript.generation.EventBinder;
import com.intellij.lang.javascript.generation.JSNamedElementNode;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.intentions.JSFunctionsHelper;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.refactoring.JSChangeVisibilityUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMethodsFix;
import com.intellij.lang.javascript.validation.fixes.CreateJSVariableIntentionAction;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptGenerateAccessorHandler
extends BaseJSGenerateHandler {
    public static final String FLASH_EVENT_FQN = "flash.events.Event";
    public static final String PARAMETER_NAME = "value";
    private final GenerationMode myMode;
    private JCheckBox myMakePrivate;
    private BindablePropertiesForm myBindablePropertiesForm;

    public JavaScriptGenerateAccessorHandler(GenerationMode mode) {
        this.myMode = mode;
    }

    @Override
    protected String getTitleKey() {
        return this.myMode == GenerationMode.Getter ? "generate.getter.fields.chooser.title" : (this.myMode == GenerationMode.Setter ? "generate.setter.fields.chooser.title" : "generate.getter.setter.chooser.title");
    }

    @Override
    protected String getNoCandidatesMessage() {
        return this.myMode == GenerationMode.Getter ? JSBundle.message((String)"no.variables.for.getter", (Object[])new Object[0]) : (this.myMode == GenerationMode.Setter ? JSBundle.message((String)"no.variables.for.setter", (Object[])new Object[0]) : JSBundle.message((String)"no.variables.for.getter.setter", (Object[])new Object[0]));
    }

    @Override
    @Nullable
    protected JComponent getOptionsComponent(JSClass jsClass, Collection<JSNamedElementNode> candidates) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            for (JSNamedElementNode candidate : candidates) {
                JSAttributeList attrList;
                PsiElement element = candidate.getPsiElement();
                if (!(element instanceof JSVariable) || (attrList = ((JSVariable)element).getAttributeList()) != null && attrList.getAccessType() == JSAttributeList.AccessType.PRIVATE) continue;
                this.myMakePrivate = new JCheckBox("Make private", true);
                this.myMakePrivate.setFocusable(false);
                this.myMakePrivate.setMnemonic('M');
                break;
            }
            if (ActionScriptEventDispatchUtils.isEventDispatcher(jsClass)) {
                this.myBindablePropertiesForm = new BindablePropertiesForm(jsClass.getProject(), this.myMode == GenerationMode.Setter || this.myMode == GenerationMode.GetterAndSetter);
                if (this.myMakePrivate != null) {
                    JPanel panel = new JPanel(new BorderLayout());
                    panel.add((Component)this.myBindablePropertiesForm.getMainPanel(), "Center");
                    panel.add((Component)this.myMakePrivate, "South");
                    return panel;
                }
                return this.myBindablePropertiesForm.getMainPanel();
            }
        }
        return this.myMakePrivate;
    }

    @Override
    protected BaseCreateMethodsFix<JSNamedElement> createFix(final JSClass jsClass) {
        boolean makePrivate;
        final EventBinder eventBinder = ApplicationManager.getApplication().isUnitTestMode() ? ActionScriptEventDispatchUtils.createTestEventBinder(jsClass) : this.myBindablePropertiesForm;
        boolean bl = makePrivate = this.myMakePrivate == null || this.myMakePrivate.isSelected();
        if (this.myMode == GenerationMode.GetterAndSetter) {
            return new BaseCreateMethodsFix<JSNamedElement>(jsClass){
                final MyBaseCreateMethodsFix generateGetterFix;
                final MyBaseCreateMethodsFix generateSetterFix;
                {
                    super(jsClass2);
                    this.generateGetterFix = new MyBaseCreateMethodsFix(GenerationMode.Getter, jsClass, eventBinder, makePrivate, null);
                    this.generateSetterFix = new MyBaseCreateMethodsFix(GenerationMode.Setter, jsClass, eventBinder, makePrivate, null);
                }

                @Override
                public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/generation/JavaScriptGenerateAccessorHandler$1", "invoke"));
                    }
                    this.evalAnchor(editor, file);
                    for (JSNamedElement e : this.getElementsToProcess()) {
                        this.generateGetterFix.fixName(e);
                        this.anchor = this.doAddOneMethod(project, this.generateGetterFix.buildFunctionText(e, null), this.anchor);
                        this.anchor = this.doAddOneMethod(project, this.generateSetterFix.buildFunctionText(e, null), this.anchor);
                    }
                    this.generateSetterFix.createEventConstantAndImportEventIfNeeded(project, editor, this.anchor, this.getElementsToProcess());
                }
            };
        }
        return new MyBaseCreateMethodsFix(this.myMode, jsClass, eventBinder, makePrivate, null);
    }

    @Override
    protected void collectCandidates(JSClass clazz, Collection<JSNamedElementNode> candidates) {
        boolean skipVarsThatHaveGetters = this.myMode == GenerationMode.Getter || this.myMode == GenerationMode.GetterAndSetter;
        boolean skipVarsThatHaveSetters = this.myMode == GenerationMode.Setter || this.myMode == GenerationMode.GetterAndSetter;
        JavaScriptGenerateAccessorHandler.collectJSVariables(clazz, candidates, skipVarsThatHaveGetters, skipVarsThatHaveSetters, false, !(clazz instanceof ES6Class));
    }

    public static class MyBaseCreateMethodsFix
    extends BaseCreateMethodsFix<JSNamedElement> {
        private static final Key<String> ACCESSOR_NAME = Key.create((String)"JavaScript.Accessor.Forced.Name");
        private static final Key<String> INNER_FIELD_NAME = Key.create((String)"JavaScript.Accessor.Forced.Inner.Name");
        private final GenerationMode myMode;
        @Nullable
        private final EventBinder myEventBinder;
        private final boolean myMakePrivate;
        private final JSCodeStyleSettings codeStyleSettings;
        @Nullable
        private final String myQualifier;

        public MyBaseCreateMethodsFix(GenerationMode mode, JSClass jsClass, @Nullable EventBinder eventBinder, boolean makePrivate, @Nullable String qualifier) {
            super(jsClass);
            this.myMode = mode;
            this.myEventBinder = eventBinder;
            this.myMakePrivate = makePrivate;
            if (qualifier == null) {
                qualifier = JSClassUtils.getDefaultFieldQualifier((PsiElement)jsClass, false);
            }
            this.myQualifier = qualifier;
            this.codeStyleSettings = JSCodeStyleSettings.getSettings(jsClass.getContainingFile(), jsClass.getProject());
        }

        @Override
        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/generation/JavaScriptGenerateAccessorHandler$MyBaseCreateMethodsFix", "invoke"));
            }
            super.invoke(project, editor, file);
            this.createEventConstantAndImportEventIfNeeded(project, editor, this.anchor, this.getElementsToProcess());
        }

        private void createEventConstantAndImportEventIfNeeded(Project project, Editor editor, PsiElement importContext, Collection<JSNamedElement> variables) {
            if ((this.myMode == GenerationMode.Setter || this.myMode == GenerationMode.GetterAndSetter) && this.myEventBinder != null && this.myEventBinder.isBindEvent()) {
                ImportUtils.importAndShortenReference(JavaScriptGenerateAccessorHandler.FLASH_EVENT_FQN, importContext, true, false);
                if (this.myEventBinder.isCreateEventConstant()) {
                    this.createEventConstant(project, editor, variables);
                }
            }
        }

        private void createEventConstant(final Project project, final Editor editor, Collection<JSNamedElement> variables) {
            assert (this.myEventBinder != null);
            ArrayList<Pair> varNameAndAccessorNameList = new ArrayList<Pair>(variables.size());
            for (JSNamedElement variable : variables) {
                varNameAndAccessorNameList.add(Pair.create((Object)variable.getName(), (Object)this.buildName(variable)));
            }
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            for (Pair varNameAndAccessorName : varNameAndAccessorNameList) {
                JSFunction jsFunction;
                PsiElement eventConstantIdentifier;
                String eventName = this.myEventBinder.getEventName((String)varNameAndAccessorName.first);
                String eventConstantName = this.myEventBinder.getEventConstantName((String)varNameAndAccessorName.first);
                if (this.myJsClass instanceof XmlBackedJSClassImpl) {
                    ((XmlBackedJSClassImpl)this.myJsClass).clearCaches();
                }
                if ((eventConstantIdentifier = MyBaseCreateMethodsFix.findEventConstantIdentifier((PsiElement)(jsFunction = this.myJsClass.findFunctionByNameAndKind((String)varNameAndAccessorName.second, JSFunction.FunctionKind.SETTER)), eventConstantName)) == null || !eventConstantIdentifier.isValid()) continue;
                final String constantDeclaration = MessageFormat.format("public static const {0}:String = \"{1}\";", eventConstantName, eventName);
                new CreateJSVariableIntentionAction(eventConstantName, true, true){

                    @Override
                    protected void buildTemplate(Template template, JSReferenceExpression referenceExpression, boolean staticContext, PsiFile file, PsiElement anchorParent) {
                        template.addTextSegment(constantDeclaration);
                    }

                    public void apply(PsiElement psiElement) {
                        this.applyFix(project, psiElement, psiElement.getContainingFile(), editor);
                    }
                }.apply(eventConstantIdentifier);
            }
        }

        @Override
        protected boolean shouldHandleNoTypeAsAnyType() {
            return true;
        }

        private static PsiElement findEventConstantIdentifier(PsiElement psiElement, final String eventConstantName) {
            final Ref elementRef = new Ref();
            PsiTreeUtil.processElements((PsiElement)psiElement, (PsiElementProcessor)new PsiElementProcessor(){

                public boolean execute(@NotNull PsiElement element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/generation/JavaScriptGenerateAccessorHandler$MyBaseCreateMethodsFix$2", "execute"));
                    }
                    if (element instanceof JSReferenceExpression && element.getText().equals(eventConstantName)) {
                        elementRef.set((Object)element);
                        return false;
                    }
                    return true;
                }
            });
            return (PsiElement)elementRef.get();
        }

        @Override
        protected String buildFunctionBodyText(String retType, JSParameterList parameterList, JSNamedElement func) {
            String semicolon = this.codeStyleSettings.USE_SEMICOLON_AFTER_STATEMENT ? ";" : "";
            String innerFieldName = (String)func.getUserData(INNER_FIELD_NAME);
            String varName = innerFieldName != null ? innerFieldName : JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)func, false);
            if (this.myMode == GenerationMode.Setter) {
                String checkNeedEvent = null;
                String dispatchEvent = null;
                if (this.myEventBinder != null && this.myEventBinder.isBindEvent()) {
                    String quotedEventNameOrConstant = this.myEventBinder.isCreateEventConstant() ? this.myEventBinder.getEventConstantName(varName) : "\"" + this.myEventBinder.getEventName(varName) + "\"";
                    dispatchEvent = "\ndispatchEvent(new Event(" + quotedEventNameOrConstant + "))" + semicolon;
                    checkNeedEvent = "if(" + varName + "==" + JavaScriptGenerateAccessorHandler.PARAMETER_NAME + ") return" + semicolon + "\n";
                }
                return new JSFunctionsHelper.AccessorsGenerator((PsiElement)this.myJsClass, StringUtil.notNullize((String)varName)).setter().setQualifier(this.myQualifier).setNamedElement(func).setBeforeText(checkNeedEvent).setAfterText(dispatchEvent).generate();
            }
            if (this.myMode == GenerationMode.Getter) {
                return new JSFunctionsHelper.AccessorsGenerator((PsiElement)this.myJsClass, StringUtil.notNullize((String)varName)).setQualifier(this.myQualifier).setNamedElement(func).generate();
            }
            return " {}";
        }

        @Override
        protected void adjustAttributeList(JSAttributeListWrapper attributeListWrapper, JSNamedElement function) {
            attributeListWrapper.overrideAccessType(JSAttributeList.AccessType.PUBLIC);
            attributeListWrapper.removeOriginalAttributes();
            if (this.myMode == GenerationMode.Getter && this.myEventBinder != null && this.myEventBinder.isBindEvent()) {
                attributeListWrapper.addAttribute("Bindable", "event", this.myEventBinder.getEventName(function.getName()));
            }
        }

        @Override
        protected String buildFunctionKind(JSNamedElement fun) {
            if (this.myMode == GenerationMode.Getter) {
                return "get ";
            }
            if (this.myMode == GenerationMode.Setter) {
                return "set ";
            }
            return super.buildFunctionKind(fun);
        }

        @Override
        protected String buildReturnType(String typeString) {
            if (this.myMode == GenerationMode.Setter) {
                return DialectDetector.isActionScript((PsiElement)this.myJsClass) ? "void" : null;
            }
            return super.buildReturnType(typeString);
        }

        public void findOrCreateConstructorPropertyBindVariable(@NotNull JSParameter parameter) {
            JSStatement[] body;
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/lang/javascript/generation/JavaScriptGenerateAccessorHandler$MyBaseCreateMethodsFix", "findOrCreateConstructorPropertyBindVariable"));
            }
            String accessorName = JSRefactoringUtil.transformVarNameToAccessorName(parameter.getName(), this.codeStyleSettings);
            parameter.putUserData(ACCESSOR_NAME, (Object)accessorName);
            if (DialectDetector.isTypeScript((PsiElement)parameter)) {
                if (accessorName.equals(parameter.getName())) {
                    this.renameVariable((JSNamedElement)parameter, parameter.getName());
                }
                return;
            }
            JSFunction function = parameter.getDeclaringFunction();
            String innerFieldName = this.codeStyleSettings.FIELD_PREFIX + accessorName;
            parameter.putUserData(INNER_FIELD_NAME, (Object)innerFieldName);
            String nameAccess = StringUtil.notNullize((String)JSClassUtils.getDefaultFieldQualifier((PsiElement)function, true)) + innerFieldName;
            JSBlockStatement block = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)function, JSBlockStatement.class);
            if (block == null) {
                return;
            }
            for (JSStatement element : body = block.getStatements()) {
                JSReferenceExpression reference;
                JSAssignmentExpression assignment;
                JSDefinitionExpression definitionExpression;
                if (!(element instanceof JSExpressionStatement) || !(((JSExpressionStatement)element).getExpression() instanceof JSAssignmentExpression) || (definitionExpression = (assignment = (JSAssignmentExpression)((JSExpressionStatement)element).getExpression()).getDefinitionExpression()) == null || !(definitionExpression.getExpression() instanceof JSReferenceExpression) || !((reference = (JSReferenceExpression)definitionExpression.getExpression()).getQualifier() instanceof JSThisExpression) || !parameter.getName().equals(definitionExpression.getInitializerReference())) continue;
                if (innerFieldName.equals(definitionExpression.getName())) {
                    return;
                }
                if (!parameter.getName().equals(definitionExpression.getName())) continue;
                this.renameInnerPropUsages(reference, innerFieldName);
                block.deleteChildRange((PsiElement)element, (PsiElement)element);
            }
            body = block.getStatements();
            String assignmentText = nameAccess + "=" + parameter.getName() + JSCodeStyleSettings.getSemicolon(function.getContainingFile());
            PsiElement psiToInsert = JSChangeUtil.createStatementFromText(function.getProject(), assignmentText).getPsi();
            if (body.length == 0) {
                block.add(psiToInsert);
            } else {
                block.addAfter(psiToInsert, (PsiElement)body[body.length - 1]);
            }
        }

        private void renameInnerPropUsages(@NotNull JSReferenceExpression reference, @NotNull String newName) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/generation/JavaScriptGenerateAccessorHandler$MyBaseCreateMethodsFix", "renameInnerPropUsages"));
            }
            if (newName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/lang/javascript/generation/JavaScriptGenerateAccessorHandler$MyBaseCreateMethodsFix", "renameInnerPropUsages"));
            }
            PsiElement resolvedProperty = reference.resolve();
            if (!(resolvedProperty instanceof JSDefinitionExpression)) {
                return;
            }
            PsiElement dummy = ((JSDefinitionExpression)resolvedProperty.copy()).setName(newName);
            assert (dummy != null);
            for (PsiReference ref : ReferencesSearch.search((PsiElement)resolvedProperty, (SearchScope)GlobalSearchScope.fileScope((PsiFile)reference.getContainingFile())).findAll()) {
                if (JSResolveUtil.getClassOfContext(ref.getElement()) != this.myJsClass || ref.getElement() == reference) continue;
                ref.bindToElement(dummy);
            }
        }

        private void renameInIndexAccessExpression(@NotNull JSDefinitionExpression definition) {
            if (definition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/intellij/lang/javascript/generation/JavaScriptGenerateAccessorHandler$MyBaseCreateMethodsFix", "renameInIndexAccessExpression"));
            }
            if (!BaseJSGenerateHandler.indexedPropertyAccessCheck((JSNamedElementBase)definition, (PairProcessor<String, String>)((PairProcessor)(existing, future) -> {
                if (definition == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/intellij/lang/javascript/generation/JavaScriptGenerateAccessorHandler$MyBaseCreateMethodsFix", "lambda$renameInIndexAccessExpression$0"));
                }
                definition.putUserData(INNER_FIELD_NAME, existing);
                definition.putUserData(ACCESSOR_NAME, future);
                return false;
            }))) {
                return;
            }
            definition.putUserData(ACCESSOR_NAME, (Object)JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)definition, false));
            JSExpression expression = definition.getExpression();
            if (expression instanceof JSReferenceExpression) {
                JSReferenceExpression reference = (JSReferenceExpression)expression;
                assert (reference.getQualifier() != null);
                JSReferenceExpression copy = (JSReferenceExpression)JSChangeUtil.createExpressionFromText(definition.getProject(), reference.getQualifier().getText() + "." + this.codeStyleSettings.FIELD_PREFIX + reference.getReferenceNameElement()).getPsi(JSReferenceExpression.class);
                this.rebindUsages((JSExpression)copy, expression);
                reference.replace((JSExpression)copy);
            } else if (expression instanceof JSIndexedPropertyAccessExpression) {
                String copyText;
                JSIndexedPropertyAccessExpression indexedAcc = (JSIndexedPropertyAccessExpression)expression;
                JSExpression indexed = indexedAcc.getIndexExpression();
                if (indexed instanceof JSLiteralExpression && ((JSLiteralExpression)indexed).isQuotedLiteral()) {
                    Convertor wrap = str -> this.codeStyleSettings.USE_DOUBLE_QUOTES ? "[\"" + str + "\"]" : "['" + str + "']";
                    String text = StringUtil.unquoteString((String)indexed.getText());
                    if (text.startsWith("_")) {
                        definition.putUserData(ACCESSOR_NAME, wrap.convert((Object)text.substring(1)));
                        definition.putUserData(INNER_FIELD_NAME, wrap.convert((Object)text));
                        return;
                    }
                    String innerPropText = (String)wrap.convert((Object)("_" + text));
                    definition.putUserData(INNER_FIELD_NAME, (Object)innerPropText);
                    definition.putUserData(ACCESSOR_NAME, wrap.convert((Object)text));
                    copyText = indexedAcc.getQualifier().getText() + innerPropText;
                } else {
                    String prefix = this.codeStyleSettings.USE_DOUBLE_QUOTES ? "\"_\"" : "'_'";
                    boolean parenthesis = !(indexed instanceof JSReferenceExpression);
                    String innerText = parenthesis ? "(" + indexed.getText() + ")" : indexed.getText();
                    String newIndexed = prefix + " + " + innerText;
                    copyText = indexedAcc.getQualifier().getText() + "[" + newIndexed + "]";
                }
                JSIndexedPropertyAccessExpression copy = (JSIndexedPropertyAccessExpression)JSChangeUtil.createExpressionFromText(definition.getProject(), copyText).getPsi(JSIndexedPropertyAccessExpression.class);
                this.rebindUsages((JSExpression)copy, expression);
                indexedAcc.replace((JSExpression)copy);
            }
        }

        private void rebindUsages(@NotNull JSExpression copy, @NotNull JSExpression expression) {
            if (copy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copy", "com/intellij/lang/javascript/generation/JavaScriptGenerateAccessorHandler$MyBaseCreateMethodsFix", "rebindUsages"));
            }
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/generation/JavaScriptGenerateAccessorHandler$MyBaseCreateMethodsFix", "rebindUsages"));
            }
            JSExpressionStatement definition = (JSExpressionStatement)JSChangeUtil.createStatementFromText(expression.getProject(), copy.getText() + "=1").getPsi(JSExpressionStatement.class);
            JSExpression assignment = definition.getExpression();
            assert (assignment instanceof JSAssignmentExpression);
            JSChangeUtil.rebindVariableUsages((PsiElement)expression, (PsiElement)((JSAssignmentExpression)assignment).getDefinitionExpression(), (PsiElement)this.myJsClass);
        }

        @Override
        protected void fixName(JSNamedElement jsVariable) {
            String varName;
            if (jsVariable instanceof JSDefinitionExpression && ((JSDefinitionExpression)jsVariable).getExpression() instanceof JSIndexedPropertyAccessExpression) {
                this.renameInIndexAccessExpression((JSDefinitionExpression)jsVariable);
                return;
            }
            if (jsVariable instanceof JSParameter && this.myJsClass instanceof ES6Class) {
                this.findOrCreateConstructorPropertyBindVariable((JSParameter)jsVariable);
                return;
            }
            String newName = JSRefactoringUtil.transformVarNameToAccessorName(super.buildName(jsVariable), this.codeStyleSettings);
            if (newName.equals(varName = jsVariable.getName()) && this.codeStyleSettings.FIELD_PREFIX.length() > 0 && !varName.startsWith(this.codeStyleSettings.FIELD_PREFIX)) {
                this.renameVariable(jsVariable, varName);
            }
            if (this.myMakePrivate && jsVariable instanceof JSVariable && !(jsVariable instanceof JSParameter)) {
                JSChangeVisibilityUtil.setVisibility((JSAttributeListOwner)jsVariable, JSAttributeList.AccessType.PRIVATE);
            }
        }

        private void renameVariable(JSNamedElement jsVariable, String varName) {
            MyBaseCreateMethodsFix.renameVariable(jsVariable, varName, this.codeStyleSettings.FIELD_PREFIX + varName, (Processor<PsiReference>)((Processor)ref -> JSResolveUtil.getClassOfContext(ref.getElement()) == this.myJsClass));
        }

        public static void renameVariable(JSNamedElement jsVariable, String varName, String newVarName, Processor<PsiReference> usageScopeChecker) {
            PsiElement copy = null;
            if (jsVariable instanceof JSParameter) {
                JSParameterList parameterList = (JSParameterList)jsVariable.getParent().copy();
                for (JSParameter jSParameter : parameterList.getParameterVariables()) {
                    if (!varName.equals(jSParameter.getName())) continue;
                    copy = jSParameter;
                    break;
                }
                if (copy == null) {
                    return;
                }
                ((JSNamedElement)copy).setName(newVarName);
            } else {
                if (jsVariable instanceof JSVariable) {
                    JSVarStatement statementCopy = (JSVarStatement)jsVariable.getParent().copy();
                    for (JSParameter jSParameter : statementCopy.getVariables()) {
                        if (!varName.equals(jSParameter.getName())) continue;
                        copy = jSParameter;
                        break;
                    }
                } else {
                    copy = jsVariable.copy();
                }
                if (copy == null) {
                    return;
                }
                ((JSNamedElement)copy).setName(newVarName);
            }
            for (PsiReference ref : ReferencesSearch.search((PsiElement)jsVariable, (SearchScope)GlobalSearchScope.fileScope((PsiFile)jsVariable.getContainingFile())).findAll()) {
                if (usageScopeChecker != null && !usageScopeChecker.process((Object)ref) || ref.getElement().getParent() == jsVariable) continue;
                ref.bindToElement(copy);
            }
            jsVariable.setName(newVarName);
        }

        @Override
        protected String buildName(JSNamedElement fun) {
            String accessorName = (String)fun.getUserData(ACCESSOR_NAME);
            if (accessorName != null) {
                return accessorName;
            }
            return JSRefactoringUtil.transformVarNameToAccessorName(super.buildName(fun), this.codeStyleSettings);
        }

        @Override
        protected String buildParameterList(JSParameterList parameterList, JSNamedElement fun, MultiMap<String, String> types) {
            if (this.myMode == GenerationMode.Setter) {
                String stringType = null;
                if (fun instanceof JSVariable) {
                    JSType type = ((JSVariable)fun).getType();
                    stringType = DialectDetector.isTypeScript((PsiElement)fun) ? MyBaseCreateMethodsFix.getProcessedType(type, this.myJsClass, (PsiElement)fun) : JSTypeEvaluateManager.getBaseArrayType(this.getTypeString(type, fun, types));
                }
                return "(value" + (stringType != null ? ":" + stringType : "") + ")";
            }
            return parameterList != null ? parameterList.getText() : "()";
        }
    }

    public static enum GenerationMode {
        Getter,
        Setter,
        GetterAndSetter;

    }
}

