/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactoryBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHighlightFunctionExitPointsHandlerFactory
extends HighlightUsagesHandlerFactoryBase {
    public HighlightUsagesHandlerBase createHighlightUsagesHandler(@NotNull Editor editor, @NotNull PsiFile file, final @NotNull PsiElement target) {
        IElementType elementType;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/highlighting/JSHighlightFunctionExitPointsHandlerFactory", "createHighlightUsagesHandler"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/highlighting/JSHighlightFunctionExitPointsHandlerFactory", "createHighlightUsagesHandler"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/lang/javascript/highlighting/JSHighlightFunctionExitPointsHandlerFactory", "createHighlightUsagesHandler"));
        }
        ASTNode node = target.getNode();
        if (node != null && ((elementType = node.getElementType()) == JSTokenTypes.RETURN_KEYWORD || elementType == JSTokenTypes.THROW_KEYWORD || elementType == JSTokenTypes.FUNCTION_KEYWORD || elementType == JSTokenTypes.EQGT)) {
            return new HighlightUsagesHandlerBase<PsiElement>(editor, file){

                public List<PsiElement> getTargets() {
                    return new SmartList((Object)target);
                }

                @Nullable
                public String getFeatureId() {
                    return "codeassists.highlight.return";
                }

                protected void selectTargets(List<PsiElement> targets, Consumer<List<PsiElement>> selectionConsumer) {
                    selectionConsumer.consume(targets);
                }

                public void computeUsages(List<PsiElement> targets) {
                    final JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)targets.get(0), JSFunction.class);
                    JSExpression arrowFunctionReturnExpression = JSPsiImplUtils.tryGetArrowFunctionReturnExpression(fun);
                    if (arrowFunctionReturnExpression != null) {
                        this.myReadUsages.add(arrowFunctionReturnExpression.getTextRange());
                        return;
                    }
                    if (fun != null) {
                        ASTNode rbrace;
                        JSBlockStatement block;
                        fun.acceptChildren((PsiElementVisitor)new JSRecursiveElementVisitor(){

                            public void visitJSReturnStatement(JSReturnStatement node) {
                                super.visitJSReturnStatement(node);
                                myReadUsages.add(node.getTextRange());
                            }

                            public void visitJSThrowStatement(JSThrowStatement node) {
                                super.visitJSThrowStatement(node);
                                JSTryStatement tryStatement = (JSTryStatement)PsiTreeUtil.getParentOfType((PsiElement)node, JSTryStatement.class);
                                if (tryStatement != null && PsiTreeUtil.findCommonParent((PsiElement)tryStatement, (PsiElement)fun) == fun) {
                                    return;
                                }
                                myReadUsages.add(node.getTextRange());
                            }

                            public void visitJSFunctionExpression(JSFunctionExpression node) {
                            }

                            public void visitJSFunctionDeclaration(JSFunction node) {
                            }
                        });
                        JSSourceElement[] body = fun.getBody();
                        if (body.length == 1 && body[0] instanceof JSBlockStatement && ControlFlowUtils.blockMayCompleteNormally(block = (JSBlockStatement)body[0]) && (rbrace = block.getNode().findChildByType(JSTokenTypes.RBRACE)) != null) {
                            this.myReadUsages.add(rbrace.getTextRange());
                        }
                    }
                }
            };
        }
        return null;
    }
}

