/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inject;

import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.MultiHostRegistrarImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSInjectionUtil {
    private static final Key<Boolean> FORMATTABLE_INJECTION_KEY = new Key("js.injection.formattable");

    private JSInjectionUtil() {
    }

    public static void setReformattableInjection(@NotNull MultiHostRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/lang/javascript/inject/JSInjectionUtil", "setReformattableInjection"));
        }
        PsiFile file = JSInjectionUtil.getInjectedFile(registrar);
        if (file != null) {
            file.putUserData(FORMATTABLE_INJECTION_KEY, (Object)true);
        }
    }

    public static boolean isReformattableInjectedPsi(PsiFile psi) {
        return psi.getUserData(FORMATTABLE_INJECTION_KEY) == Boolean.TRUE;
    }

    public static boolean isFormattableHost(@NotNull PsiElement host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/inject/JSInjectionUtil", "isFormattableHost"));
        }
        return host.isPhysical() && host.getNode().getElementType() == JSStubElementTypes.STRING_TEMPLATE_EXPRESSION;
    }

    public static boolean hostContainsFormattableInjection(@NotNull PsiElement host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/inject/JSInjectionUtil", "hostContainsFormattableInjection"));
        }
        if (!JSInjectionUtil.isFormattableHost(host)) {
            return false;
        }
        final Ref result = Ref.create(null);
        InjectedLanguageUtil.enumerate((PsiElement)host, (PsiLanguageInjectionHost.InjectedPsiVisitor)new PsiLanguageInjectionHost.InjectedPsiVisitor(){

            public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                if (injectedPsi == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "com/intellij/lang/javascript/inject/JSInjectionUtil$1", "visit"));
                }
                if (places == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "places", "com/intellij/lang/javascript/inject/JSInjectionUtil$1", "visit"));
                }
                result.set((Object)(JSInjectionUtil.isReformattableInjectedPsi(injectedPsi) && places.size() == 1 ? 1 : 0));
            }
        });
        return Boolean.TRUE == result.get();
    }

    @Nullable
    private static PsiFile getInjectedFile(@NotNull MultiHostRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/lang/javascript/inject/JSInjectionUtil", "getInjectedFile"));
        }
        List result = ((MultiHostRegistrarImpl)registrar).getResult();
        return result == null || result.isEmpty() ? null : (PsiFile)((Pair)result.get((int)(result.size() - 1))).second;
    }
}

