/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSPrimitiveTypeWrapperUsageInspection
extends JSInspection
implements CleanupLocalInspectionTool {
    private static final Set<String> PRIMITIVE_TYPE_WRAPPERS = new THashSet(3);

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSNewExpression(JSNewExpression node) {
                JSExpression expression = node.getMethodExpression();
                if (expression != null) {
                    String text = expression.getText();
                    if (PRIMITIVE_TYPE_WRAPPERS.contains(text)) {
                        holder.registerProblem((PsiElement)node, JSBundle.message((String)"js.primitive.type.wrapper.usage.inspection", (Object[])new Object[0]), new LocalQuickFix[]{new ReplaceWithPrimitiveCounterpartQuickFix(text.toLowerCase())});
                    } else if ("Array".equals(text) && node.getArguments().length != 1 || "Object".equals(text) && node.getArguments().length == 0) {
                        holder.registerProblem((PsiElement)node, JSBundle.message((String)"js.primitive.type.improper.instantiation.inspection", (Object[])new Object[]{text}), new LocalQuickFix[]{new ReplaceWithSimpleInstantiation(text.toLowerCase())});
                    }
                }
            }

            public void visitJSAssignmentExpression(JSAssignmentExpression node) {
                JSExpression lExpr = node.getLOperand();
                if (lExpr == null) {
                    return;
                }
                if (lExpr instanceof JSDefinitionExpression) {
                    lExpr = ((JSDefinitionExpression)lExpr).getExpression();
                }
                if (lExpr == null) {
                    return;
                }
                if (lExpr instanceof JSReferenceExpression) {
                    JSExpression qualifier = ((JSReferenceExpression)lExpr).getQualifier();
                    boolean forbidNewProperties = false;
                    if (qualifier instanceof JSLiteralExpression) {
                        forbidNewProperties = true;
                    } else if (qualifier instanceof JSReferenceExpression) {
                        if ("prototype".equals(((JSReferenceExpression)qualifier).getReferencedName())) {
                            return;
                        }
                        JSType type = JSResolveUtil.getExpressionJSType(qualifier);
                        if (type instanceof JSPrimitiveType) {
                            forbidNewProperties = true;
                        }
                    }
                    if (forbidNewProperties) {
                        holder.registerProblem((PsiElement)lExpr, JSBundle.message((String)"js.assigning.to.primitive.type.property", (Object[])new Object[0]), new LocalQuickFix[0]);
                    }
                }
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSPrimitiveTypeWrapperUsageInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    static {
        PRIMITIVE_TYPE_WRAPPERS.add("Boolean");
        PRIMITIVE_TYPE_WRAPPERS.add("Number");
        PRIMITIVE_TYPE_WRAPPERS.add("String");
    }

    static class ReplaceWithSimpleInstantiation
    implements LocalQuickFix {
        private final String myLiteralName;

        public ReplaceWithSimpleInstantiation(String literalName) {
            this.myLiteralName = literalName;
        }

        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"js.replace.with.literal", (Object[])new Object[]{this.myLiteralName});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSPrimitiveTypeWrapperUsageInspection$ReplaceWithSimpleInstantiation", "getFamilyName"));
            }
            return string;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            String replacement;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/JSPrimitiveTypeWrapperUsageInspection$ReplaceWithSimpleInstantiation", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/inspections/JSPrimitiveTypeWrapperUsageInspection$ReplaceWithSimpleInstantiation", "applyFix"));
            }
            JSNewExpression newExpression = (JSNewExpression)descriptor.getPsiElement();
            PsiFile file = newExpression.getContainingFile();
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
            if (document == null) {
                return;
            }
            JSExpression expression = newExpression.getMethodExpression();
            if (expression == null) {
                return;
            }
            String text = expression.getText();
            if ("Array".equals(text)) {
                JSExpression[] arguments = newExpression.getArguments();
                if (arguments.length > 1) {
                    TextRange range = new TextRange(arguments[0].getTextRange().getStartOffset(), arguments[arguments.length - 1].getTextRange().getEndOffset());
                    replacement = "[" + document.getText(range) + "]";
                } else {
                    if (arguments.length != 0) return;
                    replacement = "[]";
                }
            } else {
                replacement = "{}";
            }
            document.replaceString(newExpression.getTextRange().getStartOffset(), newExpression.getTextRange().getEndOffset(), (CharSequence)replacement);
        }
    }

    static class ReplaceWithPrimitiveCounterpartQuickFix
    implements LocalQuickFix {
        private String myPrimitiveName;

        public ReplaceWithPrimitiveCounterpartQuickFix(String primitiveName) {
            this.myPrimitiveName = primitiveName;
        }

        @NotNull
        public String getName() {
            String string = JSBundle.message((String)"js.replace.with.type.cast.to.primitive", (Object[])new Object[]{this.myPrimitiveName});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSPrimitiveTypeWrapperUsageInspection$ReplaceWithPrimitiveCounterpartQuickFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"js.replace.with.type.cast.to.primitive", (Object[])new Object[]{""});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSPrimitiveTypeWrapperUsageInspection$ReplaceWithPrimitiveCounterpartQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/JSPrimitiveTypeWrapperUsageInspection$ReplaceWithPrimitiveCounterpartQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/inspections/JSPrimitiveTypeWrapperUsageInspection$ReplaceWithPrimitiveCounterpartQuickFix", "applyFix"));
            }
            JSNewExpression newExpression = (JSNewExpression)descriptor.getPsiElement();
            PsiFile file = newExpression.getContainingFile();
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
            if (document != null) {
                document.deleteString(newExpression.getTextOffset(), newExpression.getMethodExpression().getTextOffset());
            }
        }
    }
}

