/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.json;

import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.impl.JsonPropertyNameReference;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class JsonPropertyReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/lang/javascript/json/JsonPropertyReferenceContributor", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(JsonProperty.class), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/json/JsonPropertyReferenceContributor$1", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/json/JsonPropertyReferenceContributor$1", "getReferencesByElement"));
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{new JsonToJavaScriptPropertyReference((JsonProperty)element)};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/json/JsonPropertyReferenceContributor$1", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
    }

    private static class JsonToJavaScriptPropertyReference
    extends JsonPropertyNameReference {
        public JsonToJavaScriptPropertyReference(@NotNull JsonProperty element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/json/JsonPropertyReferenceContributor$JsonToJavaScriptPropertyReference", "<init>"));
            }
            super(element);
        }

        public boolean isReferenceTo(PsiElement element) {
            if (element instanceof JSDefinitionExpression) {
                element = ((JSDefinitionExpression)element).getExpression();
            }
            String possiblePropertyName = null;
            if (element instanceof JSReferenceExpression) {
                JSReferenceExpression referenceExpression = (JSReferenceExpression)element;
                if (referenceExpression.getQualifier() != null) {
                    possiblePropertyName = referenceExpression.getReferencedName();
                }
            } else if (element instanceof JSProperty) {
                possiblePropertyName = ((JSProperty)element).getName();
            }
            return possiblePropertyName != null && this.getCanonicalText().equals(possiblePropertyName) && DialectDetector.isJavaScriptFamily(element);
        }
    }
}

