/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library.stat;

import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSScopeUsagesCollector
extends AbstractApplicationUsagesCollector {
    public static final String GROUP_ID = "javaScript Scope Usages";

    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) throws CollectUsagesException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/library/stat/JSScopeUsagesCollector", "getProjectUsages"));
        }
        HashSet scopeDescriptors = new HashSet();
        JSLibraryMappings mappings = (JSLibraryMappings)((Object)ServiceManager.getService((Project)project, JSLibraryMappings.class));
        Map map = mappings.getMappings();
        for (VirtualFile keyFile : map.keySet()) {
            ScriptingLibraryModel association = keyFile != null ? (ScriptingLibraryModel)map.get(keyFile) : (ScriptingLibraryModel)mappings.getMapping(null);
            int count = 1;
            if (association instanceof ScriptingLibraryMappings.CompoundLibrary) {
                count = ((ScriptingLibraryMappings.CompoundLibrary)association).getLibraryCount();
            }
            for (int i = 0; i < count; ++i) {
                if (keyFile == null) {
                    scopeDescriptors.add(new UsageDescriptor("Project", 1));
                    continue;
                }
                if (keyFile.isDirectory()) {
                    scopeDescriptors.add(new UsageDescriptor("Directory", 1));
                    continue;
                }
                scopeDescriptors.add(new UsageDescriptor("File", 1));
            }
        }
        HashSet hashSet = scopeDescriptors;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/stat/JSScopeUsagesCollector", "getProjectUsages"));
        }
        return hashSet;
    }

    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create((String)GROUP_ID);
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/stat/JSScopeUsagesCollector", "getGroupId"));
        }
        return groupDescriptor;
    }
}

