/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.linter.JSLinterDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectConfigurator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLinterGuesser
implements DirectoryProjectConfigurator {
    public static final Logger LOG = Logger.getInstance(JSLinterGuesser.class);

    public void configureProject(Project project, @NotNull VirtualFile baseDir, Ref<Module> moduleRef) {
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/lang/javascript/linter/JSLinterGuesser", "configureProject"));
        }
        if (project.isDefault()) {
            return;
        }
        PackageJsonData packageJson = PackageJsonUtil.getTopLevelPackageJsonData(project);
        List descriptors = Arrays.stream(JSLinterDescriptor.EP_NAME.getExtensions()).sorted(Comparator.comparing(t -> t.getPriority().value)).collect(Collectors.toList());
        DumbAwareRunnable dumbAwareRunnable = () -> JSLinterGuesser.guessLinters(project, packageJson, descriptors);
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized((Runnable)dumbAwareRunnable);
    }

    private static void guessLinters(@NotNull Project project, @Nullable PackageJsonData packageJson, @NotNull List<JSLinterDescriptor> descriptors) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterGuesser", "guessLinters"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/lang/javascript/linter/JSLinterGuesser", "guessLinters"));
        }
        for (JSLinterDescriptor descriptor : descriptors) {
            boolean packageJsonContainsSection;
            boolean packageNameInDependencies = packageJson != null && packageJson.getAllDependencies().contains(descriptor.packageName());
            boolean bl = packageJsonContainsSection = packageJson != null && packageJson.getTopLevelProperties().contains(descriptor.packageJsonSectionName());
            if (packageNameInDependencies || packageJsonContainsSection) {
                String reason = packageNameInDependencies ? ", because package.json contains " + descriptor.packageName() + " in dependencies" : ", because package.json has a section " + descriptor.packageJsonSectionName();
                JSLinterGuesser.doLog("Turning on " + JSLinterGuesser.getName(descriptor) + " in project " + project.getName() + reason);
                descriptor.enable(project);
                continue;
            }
            if (!descriptor.hasConfigFiles(project)) continue;
            JSLinterGuesser.doLog("Turning on " + JSLinterGuesser.getName(descriptor) + " in project " + project.getName() + ", because a config file found.");
            descriptor.enable(project);
        }
    }

    private static String getName(JSLinterDescriptor descriptor) {
        return descriptor.getClass().getSimpleName().replace("LinterDescriptor", "");
    }

    private static void doLog(String message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(message);
        }
    }
}

