/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ESLintJsonProblemsParser {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.linter.eslint.ESLintJsonProblemsParser");
    private final JsonObject myObject;

    public ESLintJsonProblemsParser(JsonObject object) {
        this.myObject = object;
    }

    @Nullable
    public String getGlobalError() {
        JsonElement error = this.myObject.get("error");
        return error != null && error.isJsonPrimitive() && ((JsonPrimitive)error).isString() && !StringUtil.isEmptyOrSpaces((String)error.getAsString()) ? error.getAsString() : null;
    }

    @NotNull
    public List<JSLinterError> getErrors() {
        List<JSLinterError> list = this.parse();
        List<Object> list2 = list == null ? Collections.emptyList() : list;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/ESLintJsonProblemsParser", "getErrors"));
        }
        return list2;
    }

    @Nullable
    private List<JSLinterError> parse() {
        JsonArray values;
        JsonElement body = this.myObject.get("body");
        if (body == null) {
            return null;
        }
        if (!body.isJsonArray()) {
            LOG.warn("ESLint: Unexpected body type: not an array: " + body.getAsString());
            return null;
        }
        JsonArray list = body.getAsJsonArray();
        if (list.size() == 0) {
            return null;
        }
        JsonElement value = list.get(0);
        if (!(value instanceof JsonObject)) {
            LOG.warn("ESLint: answer is not an object");
            return null;
        }
        JsonObject object = (JsonObject)value;
        JsonElement messages = object.get("messages");
        if (messages == null || !messages.isJsonArray() || (values = (JsonArray)messages).size() == 0) {
            return null;
        }
        ArrayList elements = new ArrayList();
        values.forEach(v -> elements.add(v));
        return elements.stream().map(message -> {
            HighlightSeverity hs;
            if (!(message instanceof JsonObject)) {
                return null;
            }
            Parser parser = new Parser((JsonObject)message);
            String ruleId = parser.getOptionalString("ruleId");
            String messageText = parser.getString("message");
            Integer line = parser.getInteger("line");
            Integer column = parser.getInteger("column");
            if (parser.isFailed()) {
                return null;
            }
            JsonElement severityP = parser.myObject.get("severity");
            if (severityP.isJsonPrimitive() && severityP.getAsJsonPrimitive().isNumber()) {
                int intV = severityP.getAsJsonPrimitive().getAsInt();
                if (intV == 0) {
                    return null;
                }
                if (intV == 1) {
                    hs = HighlightSeverity.WARNING;
                    return new JSLinterError(line, column, messageText, ruleId, hs);
                } else {
                    if (intV != 2) return null;
                    hs = HighlightSeverity.ERROR;
                }
                return new JSLinterError(line, column, messageText, ruleId, hs);
            } else {
                if (!severityP.isJsonPrimitive() || !severityP.getAsJsonPrimitive().isString()) return null;
                String string = severityP.getAsJsonPrimitive().getAsString();
                if ("error".equals(StringUtil.unquoteString((String)string))) {
                    hs = HighlightSeverity.ERROR;
                    return new JSLinterError(line, column, messageText, ruleId, hs);
                } else {
                    if (!"warning".equals(StringUtil.unquoteString((String)string))) return null;
                    hs = HighlightSeverity.WARNING;
                }
            }
            return new JSLinterError(line, column, messageText, ruleId, hs);
        }).filter(item -> item != null).collect(Collectors.toList());
    }

    private static class Parser {
        private boolean myFailed;
        private final JsonObject myObject;

        private Parser(JsonObject object) {
            this.myObject = object;
        }

        public String getString(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/linter/eslint/ESLintJsonProblemsParser$Parser", "getString"));
            }
            JsonElement property = this.myObject.get(name);
            this.myFailed |= property == null || !property.isJsonPrimitive() || !property.getAsJsonPrimitive().isString();
            return this.myFailed ? null : StringUtil.unquoteString((String)property.getAsJsonPrimitive().getAsString());
        }

        public Integer getInteger(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/linter/eslint/ESLintJsonProblemsParser$Parser", "getInteger"));
            }
            JsonElement property = this.myObject.get(name);
            this.myFailed |= property == null || !property.isJsonPrimitive() || !property.getAsJsonPrimitive().isNumber();
            return this.myFailed ? null : Integer.valueOf(property.getAsJsonPrimitive().getAsInt());
        }

        public boolean isFailed() {
            return this.myFailed;
        }

        public String getOptionalString(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/linter/eslint/ESLintJsonProblemsParser$Parser", "getOptionalString"));
            }
            JsonElement property = this.myObject.get(name);
            if (property == null || property.isJsonNull()) {
                return null;
            }
            this.myFailed |= !property.isJsonPrimitive() || !property.getAsJsonPrimitive().isString();
            return this.myFailed ? null : StringUtil.unquoteString((String)property.getAsJsonPrimitive().getAsString());
        }
    }
}

