/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.linter.JSLinterBaseView;
import com.intellij.lang.javascript.linter.JSLinterState;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.lang.javascript.linter.ui.JSLinterConfigFileTexts;
import com.intellij.lang.javascript.linter.ui.JSLinterConfigFileView;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.ProjectScope;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullProducer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EslintView
extends JSLinterBaseView<UiState> {
    private final NodeJsInterpreterField myNodeInterpreterField;
    private final NodePackageField myEslintPackageField;
    private final JSLinterConfigFileView myConfigFileView;
    private final TextFieldWithBrowseButton myAdditionalRulesDirField;
    private final RawCommandLineEditor myExtraOptions;
    private final JPanel myCenterPanel;
    private final JPanel myConfigurationPanel;
    private final JLabel myPackageErrorLabel;

    public EslintView(@NotNull Project project, boolean fullModeDialog) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintView", "<init>"));
        }
        super(fullModeDialog);
        this.myNodeInterpreterField = new NodeJsInterpreterField(project, false);
        List packageNames = ContainerUtil.list((Object[])new String[]{"eslint", "standard"});
        this.myEslintPackageField = new NodePackageField(project, packageNames, () -> this.myNodeInterpreterField.getInterpreter());
        this.myConfigFileView = new JSLinterConfigFileView(project, new JSLinterConfigFileTexts(JSBundle.message((String)"eslint.configurable.config.autoSearch.title", (Object[])new Object[0]), JSBundle.message((String)"eslint.configurable.config.autoSearch.description.bodyInnerHtml", (Object[])new Object[0]), JSBundle.message((String)"eslint.configurable.config.select.config.text", (Object[])new Object[0]), "In each case, the settings in the configuration file override default settings."), null);
        this.myConfigFileView.setAdditionalConfigFilesProducer((NotNullProducer<List<VirtualFile>>)((NotNullProducer)() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintView", "lambda$new$1"));
            }
            return EslintUtil.findAllConfigsInScope(project, ProjectScope.getContentScope((Project)project));
        }));
        this.myAdditionalRulesDirField = EslintView.createAdditionalRulesDirField(project);
        this.myExtraOptions = new RawCommandLineEditor();
        this.myExtraOptions.setDialogCaption("Extra ESLint Options");
        this.myConfigurationPanel = FormBuilder.createFormBuilder().addComponent((JComponent)this.myConfigFileView.getComponent()).addSeparator(4).addVerticalGap(4).addComponent(EslintView.createBottomComponent(this.myAdditionalRulesDirField, this.myExtraOptions)).getPanel();
        this.myEslintPackageField.addSelectionListener((Consumer<NodePackage>)((Consumer)nodePackage -> {
            this.updateCustomErrorMessage((NodePackage)nodePackage);
            this.myConfigurationPanel.setVisible(!EslintView.isStandardJs(nodePackage));
        }));
        this.myPackageErrorLabel = new JLabel("");
        this.myPackageErrorLabel.setFont(UIUtil.getTitledBorderFont());
        JPanel panel = FormBuilder.createFormBuilder().setAlignLabelOnRight(true).setHorizontalGap(10).setVerticalGap(4).setFormLeftIndent(10).addLabeledComponent("&Node interpreter:", (JComponent)((Object)this.myNodeInterpreterField)).addLabeledComponent(JSBundle.message((String)"eslint.configurable.eslintPackage.label", (Object[])new Object[0]), (JComponent)((Object)this.myEslintPackageField)).addComponentToRightColumn((JComponent)this.myPackageErrorLabel).addComponentToRightColumn(EslintView.createStandardJSLabel()).addComponent((JComponent)this.myConfigurationPanel).getPanel();
        this.myCenterPanel = SwingHelper.wrapWithHorizontalStretch((JComponent)panel);
        this.myCenterPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
    }

    @NotNull
    private static JComponent createStandardJSLabel() {
        JLabel label = new JLabel();
        label.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        Color foreground = UIUtil.getLabelDisabledForeground();
        label.setForeground(foreground);
        label.setText(JSBundle.message((String)"standardjs.eslint.label", (Object[])new Object[0]));
        JLabel jLabel = label;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintView", "createStandardJSLabel"));
        }
        return jLabel;
    }

    @NotNull
    private static JComponent createBottomComponent(@NotNull TextFieldWithBrowseButton field, @NotNull RawCommandLineEditor extraOptions) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/lang/javascript/linter/eslint/EslintView", "createBottomComponent"));
        }
        if (extraOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraOptions", "com/intellij/lang/javascript/linter/eslint/EslintView", "createBottomComponent"));
        }
        JPanel jPanel = FormBuilder.createFormBuilder().setAlignLabelOnRight(true).setHorizontalGap(10).addLabeledComponent(JSBundle.message((String)"eslint.configurable.additionalRulesDir.label", (Object[])new Object[0]), (JComponent)field).addLabeledComponent(JSBundle.message((String)"eslint.configurable.extraOptions.label", (Object[])new Object[0]), (JComponent)extraOptions).getPanel();
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintView", "createBottomComponent"));
        }
        return jPanel;
    }

    @NotNull
    private static TextFieldWithBrowseButton createAdditionalRulesDirField(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintView", "createAdditionalRulesDirField"));
        }
        TextFieldWithBrowseButton field = new TextFieldWithBrowseButton();
        SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithBrowseButton)field, (String)JSBundle.message((String)"eslint.configurable.additionalRulesDir.browseDialogTitle", (Object[])new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor());
        TextFieldWithBrowseButton textFieldWithBrowseButton = field;
        if (textFieldWithBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintView", "createAdditionalRulesDirField"));
        }
        return textFieldWithBrowseButton;
    }

    @Override
    @Nullable
    protected Component createTopRightComponent() {
        return null;
    }

    @Override
    @NotNull
    protected Component createCenterComponent() {
        JPanel jPanel = this.myCenterPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintView", "createCenterComponent"));
        }
        return jPanel;
    }

    @Override
    protected void handleEnableStatusChanged(boolean enabled) {
        this.myConfigFileView.onEnabledStateChanged(enabled);
    }

    @Override
    @NotNull
    protected UiState getState() {
        UiState uiState = new UiState(this.getEslintState(), EslintView.isStandardJs(this.myEslintPackageField.getSelected()));
        if (uiState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintView", "getState"));
        }
        return uiState;
    }

    @Override
    protected void setState(@NotNull UiState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/eslint/EslintView", "setState"));
        }
        this.setEslintState(state.myState);
        this.myConfigurationPanel.setVisible(!state.isStandardJS);
    }

    private EslintState getEslintState() {
        NodePackage selected = this.myEslintPackageField.getSelected();
        EslintState.Builder builder = new EslintState.Builder();
        builder.setInterpreterRef(this.myNodeInterpreterField.getInterpreterRef());
        builder.setEslintPackagePath(selected.getSystemDependentPath());
        builder.setCustomConfigFilePath(this.myConfigFileView.getCustomConfigFilePath());
        builder.setCustomConfigFileUsed(this.myConfigFileView.isCustomConfigFileUsed());
        builder.setAdditionalRulesDirPath(this.myAdditionalRulesDirField.getText());
        builder.setExtraOptions(this.myExtraOptions.getText());
        return builder.build();
    }

    private void setEslintState(@NotNull EslintState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/eslint/EslintView", "setEslintState"));
        }
        this.myConfigurationPanel.setEnabled(true);
        this.myNodeInterpreterField.setInterpreterRef(state.getInterpreterRef());
        this.myEslintPackageField.setSelected(new NodePackage(state.getEslintPackagePath()));
        this.myConfigFileView.setCustomConfigFileUsed(state.isCustomConfigFileUsed());
        this.myConfigFileView.setCustomConfigFilePath(state.getCustomConfigFilePath());
        this.myAdditionalRulesDirField.setText(state.getAdditionalRulesDirPath());
        this.myExtraOptions.setText(state.getExtraOptions());
        if (this.isFullModeDialog()) {
            this.myNodeInterpreterField.setPreferredWidthToFitText();
            this.myConfigFileView.setPreferredWidthToComponents();
            SwingHelper.setPreferredWidthToFitText((TextFieldWithBrowseButton)this.myAdditionalRulesDirField);
        }
    }

    private void updateCustomErrorMessage(@NotNull NodePackage pkg) {
        if (pkg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkg", "com/intellij/lang/javascript/linter/eslint/EslintView", "updateCustomErrorMessage"));
        }
        String errorMessage = EslintView.formatErrorMessage(pkg);
        String html = XmlStringUtil.wrapInHtml((CharSequence)("<font color='#" + ColorUtil.toHex((Color)JBColor.RED) + "'>" + errorMessage + "</font>"));
        this.myPackageErrorLabel.setText(html);
    }

    @NotNull
    private static String formatErrorMessage(@NotNull NodePackage pkg) {
        if (pkg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkg", "com/intellij/lang/javascript/linter/eslint/EslintView", "formatErrorMessage"));
        }
        if (pkg.getSystemDependentPath().trim().isEmpty()) {
            if ("Empty path" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintView", "formatErrorMessage"));
            }
            return "Empty path";
        }
        if (!pkg.isValid()) {
            if ("Package directory expected" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintView", "formatErrorMessage"));
            }
            return "Package directory expected";
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintView", "formatErrorMessage"));
        }
        return "";
    }

    private static boolean isStandardJs(@NotNull NodePackage nodePackage) {
        if (nodePackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodePackage", "com/intellij/lang/javascript/linter/eslint/EslintView", "isStandardJs"));
        }
        String packageName = nodePackage.getName();
        return "standard".equals(packageName);
    }

    public static class UiState
    implements JSLinterState {
        private final EslintState myState;
        private final boolean isStandardJS;

        public UiState(@NotNull EslintState eslintState, boolean isStandardJs) {
            if (eslintState == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eslintState", "com/intellij/lang/javascript/linter/eslint/EslintView$UiState", "<init>"));
            }
            this.myState = eslintState;
            this.isStandardJS = isStandardJs;
        }

        @NotNull
        public EslintState getState() {
            EslintState eslintState = this.myState;
            if (eslintState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintView$UiState", "getState"));
            }
            return eslintState;
        }

        public boolean isStandardJS() {
            return this.isStandardJS;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UiState state = (UiState)o;
            if (this.isStandardJS != state.isStandardJS) {
                return false;
            }
            return this.myState.equals(state.myState);
        }

        public int hashCode() {
            int result = this.myState.hashCode();
            result = 31 * result + (this.isStandardJS ? 1 : 0);
            return result;
        }

        public String toString() {
            return "UiState{myState=" + this.myState + ", isStandardJS=" + this.isStandardJS + '}';
        }
    }
}

