/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.service;

import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.eslint.ESLintJsonProblemsParser;
import com.intellij.lang.javascript.linter.eslint.service.commands.ESLintFixErrorsCommand;
import com.intellij.lang.javascript.linter.eslint.service.commands.ESLintGetErrorsCommand;
import com.intellij.lang.javascript.linter.eslint.service.protocol.ESLintLanguageServiceProtocol;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceDefaultCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceQueueImpl;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ESLintLanguageService
extends JSLanguageServiceBase {
    public static ESLintLanguageService getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/service/ESLintLanguageService", "getInstance"));
        }
        return (ESLintLanguageService)ServiceManager.getService((Project)project, ESLintLanguageService.class);
    }

    public ESLintLanguageService(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/service/ESLintLanguageService", "<init>"));
        }
        super(project);
    }

    @Override
    @NotNull
    protected JSLanguageServiceQueue.ServiceInfoReporter createDefaultReporter() {
        JSLanguageServiceBase.NotificationLanguageServiceReporter notificationLanguageServiceReporter = new JSLanguageServiceBase.NotificationLanguageServiceReporter(this, JSLinterUtil.NOTIFICATION_GROUP, super.createDefaultReporter());
        if (notificationLanguageServiceReporter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/service/ESLintLanguageService", "createDefaultReporter"));
        }
        return notificationLanguageServiceReporter;
    }

    @Nullable
    public final Future<Pair<String, List<JSLinterError>>> highlight(@Nullable VirtualFile virtualFile, @Nullable VirtualFile config, @Nullable String content, String extraOptions) {
        if (StringUtil.isEmptyOrSpaces((String)content) || virtualFile == null) {
            return null;
        }
        JSLanguageServiceQueue process = this.getProcess();
        if (process == null) {
            return null;
        }
        String configPath = config == null ? null : JSLanguageServiceUtil.normalizeNameAndPath(config);
        String path = JSLanguageServiceUtil.normalizeNameAndPath(virtualFile);
        if (path == null) {
            return null;
        }
        ESLintGetErrorsCommand command = new ESLintGetErrorsCommand(path, configPath, StringUtil.notNullize((String)content), extraOptions);
        return process.execute(command, ESLintLanguageService.createHighlightProcessor());
    }

    @Nullable
    public final Future<Pair<String, List<JSLinterError>>> highlightAndFix(@Nullable VirtualFile virtualFile, @Nullable VirtualFile config, String extraOptions) {
        if (virtualFile == null || config == null) {
            return null;
        }
        JSLanguageServiceQueue process = this.getProcess();
        if (process == null) {
            return null;
        }
        String configPath = JSLanguageServiceUtil.normalizeNameAndPath(config);
        if (configPath == null) {
            return null;
        }
        String path = JSLanguageServiceUtil.normalizeNameAndPath(virtualFile);
        if (path == null) {
            return null;
        }
        ESLintFixErrorsCommand command = new ESLintFixErrorsCommand(path, configPath, extraOptions);
        return process.execute(command, ESLintLanguageService.createHighlightProcessor());
    }

    @NotNull
    private static JSLanguageServiceCommandProcessor<Pair<String, List<JSLinterError>>> createHighlightProcessor() {
        JSLanguageServiceCommandProcessor<Pair<String, List<JSLinterError>>> jSLanguageServiceCommandProcessor = (serviceObject, answer) -> {
            ESLintJsonProblemsParser parser = new ESLintJsonProblemsParser(answer.getElement());
            return Pair.create((Object)parser.getGlobalError(), parser.getErrors());
        };
        if (jSLanguageServiceCommandProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/service/ESLintLanguageService", "createHighlightProcessor"));
        }
        return jSLanguageServiceCommandProcessor;
    }

    @Override
    @Nullable
    protected JSLanguageServiceQueue createLanguageServiceQueue() {
        return new JSLanguageServiceQueueImpl(this.myProject, new ESLintLanguageServiceProtocol(this.myProject, Consumer.EMPTY_CONSUMER), this.myProcessConnector, this.myDefaultReporter, new JSLanguageServiceDefaultCacheData());
    }

    @Override
    @NotNull
    protected String getProcessName() {
        if ("ESLint" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/service/ESLintLanguageService", "getProcessName"));
        }
        return "ESLint";
    }

    @Override
    protected boolean needInitToolWindow() {
        return false;
    }
}

