/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.service.protocol;

import com.intellij.lang.javascript.linter.ExtendedLinterState;
import com.intellij.lang.javascript.linter.eslint.EslintConfiguration;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.service.protocol.ESLintLanguageServiceInitialState;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceInitialState;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceNodeStdProtocolBase;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ESLintLanguageServiceProtocol
extends JSLanguageServiceNodeStdProtocolBase {
    public ESLintLanguageServiceProtocol(@NotNull Project project, @NotNull Consumer<?> readyConsumer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/service/protocol/ESLintLanguageServiceProtocol", "<init>"));
        }
        if (readyConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readyConsumer", "com/intellij/lang/javascript/linter/eslint/service/protocol/ESLintLanguageServiceProtocol", "<init>"));
        }
        super(project, readyConsumer);
    }

    public void dispose() {
    }

    @Override
    @Nullable
    protected String getNodeInterpreter() {
        ExtendedLinterState extendedState = EslintConfiguration.getInstance(this.myProject).getExtendedState();
        return JSLanguageServiceUtil.getInterpreterPathIfValid(((EslintState)extendedState.getState()).getInterpreterRef().resolve(this.myProject));
    }

    @Override
    protected JSLanguageServiceInitialState createState() {
        ESLintLanguageServiceInitialState state = new ESLintLanguageServiceInitialState();
        ExtendedLinterState extendedState = EslintConfiguration.getInstance(this.myProject).getExtendedState();
        state.eslintPackagePath = ((EslintState)extendedState.getState()).getEslintPackagePath();
        state.additionalRootDirectory = ((EslintState)extendedState.getState()).getAdditionalRulesDirPath();
        state.pluginName = "ESLint";
        File service = new File(JSLanguageServiceUtil.getPluginDirectory(this.getClass(), "languageService"), "eslint/bin/eslint-plugin-provider.js");
        if (!service.exists()) {
            JSLanguageServiceQueue.LOGGER.info("ESLint plugin not found");
        }
        state.pluginPath = service.getAbsolutePath();
        return state;
    }
}

