/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.standardjs;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterAnnotationsBuilder;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterEditSettingsAction;
import com.intellij.lang.javascript.linter.JSLinterErrorBase;
import com.intellij.lang.javascript.linter.JSLinterExternalAnnotator;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.JSLinterStandardFixes;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.JSLinterWithInspectionExternalAnnotator;
import com.intellij.lang.javascript.linter.eslint.EsLintExternalRunner;
import com.intellij.lang.javascript.linter.eslint.EslintConfigurable;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.EslintSuppressionUtil;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSConfiguration;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSFixAction;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSInspection;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSState;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardJSExternalAnnotator
extends JSLinterExternalAnnotator<StandardJSState> {
    private static final Logger LOG = Logger.getInstance(EsLintExternalRunner.class);

    public StandardJSExternalAnnotator() {
        this(true);
    }

    public StandardJSExternalAnnotator(boolean onTheFly) {
        super(onTheFly);
    }

    @Override
    @NotNull
    protected EslintConfigurable createSettingsConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSExternalAnnotator", "createSettingsConfigurable"));
        }
        EslintConfigurable eslintConfigurable = new EslintConfigurable(project, true);
        if (eslintConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSExternalAnnotator", "createSettingsConfigurable"));
        }
        return eslintConfigurable;
    }

    @Override
    protected Class<? extends JSLinterConfiguration<StandardJSState>> getConfigurationClass() {
        return StandardJSConfiguration.class;
    }

    @Override
    protected Class<? extends JSLinterInspection> getInspectionClass() {
        return StandardJSInspection.class;
    }

    @Override
    protected boolean acceptPsiFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSExternalAnnotator", "acceptPsiFile"));
        }
        return file instanceof JSFile && JSUtils.isJavaScriptFile(file);
    }

    @Override
    @Nullable
    public JSLinterAnnotationResult<StandardJSState> annotate(@NotNull JSLinterInput<StandardJSState> input) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSExternalAnnotator", "annotate"));
        }
        StandardJSState initialState = input.getState();
        if (StringUtil.isEmpty((String)initialState.getPackagePath())) {
            return null;
        }
        EslintState runnableState = StandardJSExternalAnnotator.toEslintState(initialState, input.getProject());
        if (runnableState == null) {
            JSLinterFileLevelAnnotation annotation = JSLinterUtil.getLinterPackageMissingError(input.getProject(), initialState.getPackagePath(), "standard");
            return JSLinterAnnotationResult.create(input, annotation, null);
        }
        JSLinterInput<EslintState> eslintInput = JSLinterInput.create(input.getProject(), input.getPsiFile(), input.getDocument(), input.getFileContent(), runnableState, input.getColorsScheme());
        JSLinterAnnotationResult<EslintState> eslintResult = new EsLintExternalRunner(this.isOnTheFly(), false).execute(eslintInput);
        return new JSLinterAnnotationResult<StandardJSState>(input, eslintResult.getErrors(), eslintResult.getFileLevelError(), eslintResult.getConfigFile());
    }

    @Override
    public void apply(@NotNull PsiFile file, @Nullable JSLinterAnnotationResult<StandardJSState> annotationResult, @NotNull AnnotationHolder holder) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSExternalAnnotator", "apply"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSExternalAnnotator", "apply"));
        }
        if (annotationResult == null) {
            return;
        }
        String caption = JSBundle.message((String)"standardjs.name", (Object[])new Object[0]);
        EslintConfigurable configurable = new EslintConfigurable(file.getProject(), true);
        JSLinterStandardFixes fixes = new JSLinterStandardFixes().setEditConfig(false).setEditSettingsAction(new JSLinterEditSettingsAction(configurable, JSBundle.message((String)"standardjs.edit.settings.caption", (Object[])new Object[0]), null)).setErrorToIntentionConverter((Convertor<JSLinterErrorBase, List<IntentionAction>>)((Convertor)o -> EslintSuppressionUtil.getSuppressionsForError(o, this.isOnTheFly()))).setOtherFixes(ContainerUtil.list((Object[])new IntentionAction[]{new StandardJSFixAction().asIntentionAction()}));
        new JSLinterAnnotationsBuilder<StandardJSState>(file, annotationResult, holder, StandardJSInspection.getHighlightDisplayKey(), configurable, caption + ": ", this.getInspectionClass(), fixes).setHighlightingGranularity(JSLinterWithInspectionExternalAnnotator.HighlightingGranularity.element).apply();
    }

    @Nullable
    public static EslintState toEslintState(@NotNull StandardJSState standardJSState, @NotNull Project project) {
        if (standardJSState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "standardJSState", "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSExternalAnnotator", "toEslintState"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSExternalAnnotator", "toEslintState"));
        }
        NodePackage standardPackage = new NodePackage(standardJSState.getPackagePath());
        NodePackage eslintPackage = StandardJSUtil.findEslintPackage(standardPackage);
        NodePackage configPackage = StandardJSUtil.findConfigPackage(standardPackage);
        StandardJSUtil.ConfigData packageJsonData = StandardJSUtil.getPackageJsonConfigData(project);
        if (eslintPackage == null) {
            LOG.info(String.format("Could not find eslint package from standard package %s", standardPackage));
            return null;
        }
        if (configPackage == null) {
            LOG.info(String.format("Could not find eslint-config-standard package from standard package %s", standardPackage));
            return null;
        }
        String configFilePath = new File(configPackage.getSystemDependentPath(), "eslintrc.json").getAbsolutePath();
        if (!FileUtil.exists((String)configFilePath)) {
            LOG.info(String.format("Could not find config file from path %s", configFilePath));
            return null;
        }
        return new EslintState.Builder().setInterpreterRef(standardJSState.getInterpreterRef()).setEslintPackagePath(eslintPackage.getSystemDependentPath()).setCustomConfigFileUsed(true).setCustomConfigFilePath(configFilePath).setExtraOptions(StandardJSExternalAnnotator.getExtraOptions(packageJsonData)).build();
    }

    @NotNull
    private static String getExtraOptions(@Nullable StandardJSUtil.ConfigData configData) {
        StringBuilder commandLine = new StringBuilder("--no-eslintrc ");
        if (configData != null) {
            StandardJSExternalAnnotator.addListArgument(commandLine, "global", configData.globals);
            StandardJSExternalAnnotator.addListArgument(commandLine, "ignore-pattern", configData.ignored);
            StandardJSExternalAnnotator.addListArgument(commandLine, "env", configData.env);
            StandardJSExternalAnnotator.addListArgument(commandLine, "plugins", configData.plugins);
            if (!StringUtil.isEmpty((String)configData.parser)) {
                commandLine.append("--parser ");
                commandLine.append(configData.parser);
            }
        }
        String string = commandLine.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSExternalAnnotator", "getExtraOptions"));
        }
        return string;
    }

    private static void addListArgument(StringBuilder builder, String name, List<String> values) {
        if (!values.isEmpty()) {
            builder.append(String.format("--%s %s ", name, StringUtil.join(values, (String)",")));
        }
    }
}

