/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs.config;

import com.google.gson.JsonParseException;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.JsonReaderJSLinterUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class JscsConfigFileSearcher {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.linter.jscs.Jscs");
    private static final String PACKAGE_FILE_OPTION_NAME = "jscsConfig";
    private static final String JSCSRC = "jscsrc";
    private static final String JSCS_JSON = "jscs.json";
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myFile;
    private File myConfig;
    private File myPackage;
    private String myError;

    public JscsConfigFileSearcher(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jscs/config/JscsConfigFileSearcher", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/jscs/config/JscsConfigFileSearcher", "<init>"));
        }
        this.myProject = project;
        this.myFile = file;
    }

    public void lookup() {
        if (!this.myFile.isValid() || this.myFile.getParent() == null) {
            return;
        }
        this.browseDirectoriesUp((Processor<VirtualFile>)((Processor)file -> this.lookForPackage((VirtualFile)file) || this.lookForConfig((VirtualFile)file) || this.myError != null));
    }

    public File getConfig() {
        return this.myConfig;
    }

    public File getPackage() {
        return this.myPackage;
    }

    public String getError() {
        return this.myError;
    }

    private boolean lookForConfig(@NotNull VirtualFile file) {
        VirtualFile[] children;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/jscs/config/JscsConfigFileSearcher", "lookForConfig"));
        }
        if (this.myError != null) {
            return false;
        }
        for (VirtualFile child : children = file.getChildren()) {
            if (child.isDirectory() || !child.getName().endsWith(JSCSRC) && !child.getName().endsWith(JSCS_JSON)) continue;
            this.myConfig = new File(child.getPath());
            return true;
        }
        return false;
    }

    private boolean lookForPackage(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/jscs/config/JscsConfigFileSearcher", "lookForPackage"));
        }
        VirtualFile packageFile = file.findChild("package.json");
        if (packageFile != null && !packageFile.isDirectory() && packageFile.isValid() && this.checkPackageFileForOption(packageFile)) {
            this.myPackage = new File(packageFile.getPath());
            return true;
        }
        return false;
    }

    private boolean checkPackageFileForOption(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/jscs/config/JscsConfigFileSearcher", "checkPackageFileForOption"));
        }
        try {
            String text = JSLinterConfigFileUtil.loadActualText(file);
            return JsonReaderJSLinterUtil.hasProperty(text, PACKAGE_FILE_OPTION_NAME, file.getPath());
        }
        catch (IOException e) {
            this.myError = "Problem while reading " + file.getPath() + ": " + e.getMessage();
            LOG.info((Throwable)e);
        }
        catch (JsonParseException e) {
            this.myError = "Problem while reading " + file.getPath() + ": " + e.getMessage();
            LOG.debug((Throwable)e);
        }
        return false;
    }

    private void browseDirectoriesUp(@NotNull Processor<VirtualFile> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/linter/jscs/config/JscsConfigFileSearcher", "browseDirectoriesUp"));
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/linter/jscs/config/JscsConfigFileSearcher", "lambda$browseDirectoriesUp$1"));
            }
            if (this.myProject.isDisposed()) {
                return;
            }
            for (VirtualFile dir = this.myFile.getParent(); dir != null; dir = dir.getParent()) {
                if (!processor.process((Object)dir)) continue;
                return;
            }
        });
    }
}

