/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.inspections.FileHeaderKeeper;
import com.intellij.lang.javascript.intentions.CommentsMover;
import com.intellij.lang.javascript.modules.ImportJSModuleBaseFix;
import com.intellij.lang.javascript.modules.LastImportInScope;
import com.intellij.lang.javascript.modules.ModuleFixCreator;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ImportCommonJSModuleFix
implements ImportJSModuleBaseFix,
LocalQuickFix,
HintAction,
HighPriorityAction {
    @NotNull
    protected final ModuleFixCreator.FixDescriptor myFixDescriptor;
    protected final String myQuotes;
    private final SmartPsiElementPointer<PsiElement> myPointer;
    private volatile boolean myNeedHint;

    protected ImportCommonJSModuleFix(@NotNull PsiElement node, @NotNull ModuleFixCreator.FixDescriptor descriptor, @NotNull String quoteString) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "<init>"));
        }
        if (quoteString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quoteString", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "<init>"));
        }
        this(node, descriptor, quoteString, false);
    }

    protected ImportCommonJSModuleFix(@NotNull PsiElement node, @NotNull ModuleFixCreator.FixDescriptor descriptor, @NotNull String quoteString, boolean needHint) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "<init>"));
        }
        if (quoteString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quoteString", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "<init>"));
        }
        this.myQuotes = quoteString;
        this.myFixDescriptor = descriptor;
        this.myPointer = SmartPointerManager.getInstance((Project)node.getProject()).createSmartPsiElementPointer(node);
        this.myNeedHint = needHint;
    }

    protected boolean isAcceptableReference(@Nullable PsiElement element) {
        return element instanceof JSReferenceExpression || element instanceof JSXmlLiteralExpressionImpl;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "isAvailable"));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "invoke"));
        }
        PsiElement element = this.myPointer.getElement();
        if (element != null) {
            FileHeaderKeeper headerKeeper = new FileHeaderKeeper(JSChangeUtil.getScopeElementInFile(element));
            headerKeeper.cutHeader();
            try {
                this.invokeAction(element, editor);
            }
            finally {
                headerKeeper.returnHeader();
            }
        }
    }

    public void invokeAction(PsiElement element, Editor editor) {
        JSEmbeddedContent scope;
        JSEmbeddedContent embeddedContent = (JSEmbeddedContent)PsiTreeUtil.getParentOfType((PsiElement)element, JSEmbeddedContent.class, (boolean)false);
        boolean useEmbeddedContent = embeddedContent != null && (!DialectDetector.isJSX((PsiElement)embeddedContent) || !DialectDetector.isJSX((PsiElement)element.getContainingFile()));
        Object object = scope = useEmbeddedContent ? embeddedContent : element.getContainingFile();
        if (!this.isAcceptableReference(element)) {
            return;
        }
        if (!this.modifyExistingImports((PsiElement)scope, editor, element)) {
            PsiElement last = new LastImportInScope(this.isPreferImportAnchor()).findAndSelect((PsiElement)scope);
            PsiElement created = this.createRequire(scope.getContainingFile());
            if (last == null) {
                PsiElement child = scope.getFirstChild();
                if (child == null) {
                    scope.add(created);
                } else if (useEmbeddedContent) {
                    PsiFile dummyFile = ImportCommonJSModuleFix.createDummyFile(element.getProject(), "\n");
                    embeddedContent.addBefore(dummyFile.getFirstChild(), child);
                    scope.addBefore(created, child);
                } else {
                    scope.addBefore(created, child);
                }
            } else {
                PsiElement added = last.getParent().addAfter(created, last);
                if (last instanceof PsiComment) {
                    last.getParent().addBefore(CommentsMover.createNewLine(last), added);
                }
            }
            this.doSomethingWithCurrentFile(element, editor);
        }
        DaemonCodeAnalyzer.getInstance((Project)scope.getProject()).restart(element.getContainingFile());
    }

    protected abstract boolean modifyExistingImports(@NotNull PsiElement var1, Editor var2, @NotNull PsiElement var3);

    protected void doSomethingWithCurrentFile(PsiElement element, @Nullable Editor editor) {
        String[] tail = this.myFixDescriptor.getTail();
        if (tail == null || tail.length == 0) {
            return;
        }
        this.replaceWithNewReference(element, editor, tail[tail.length - 1]);
    }

    protected void replaceWithNewReference(@NotNull PsiElement elementTarget, @Nullable Editor editor, @NotNull String newReferenceName) {
        if (elementTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementTarget", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "replaceWithNewReference"));
        }
        if (newReferenceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newReferenceName", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "replaceWithNewReference"));
        }
        if (elementTarget instanceof JSReferenceExpression) {
            JSReferenceExpression replaceTarget = (JSReferenceExpression)elementTarget;
            if (replaceTarget.getQualifier() == null && newReferenceName.equals(replaceTarget.getReferenceName())) {
                return;
            }
            PsiFile dummy = ImportCommonJSModuleFix.createDummyFile(replaceTarget.getProject(), newReferenceName);
            PsiElement replace = replaceTarget.replace(dummy.getFirstChild());
            if (editor != null) {
                editor.getCaretModel().moveToOffset(replace.getTextRange().getEndOffset());
            }
        }
    }

    protected abstract boolean isPreferImportAnchor();

    protected abstract PsiElement createRequire(@NotNull PsiFile var1);

    protected static PsiFile createDummyFile(Project project, String text) {
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)project);
        return psiFileFactory.createFileFromText("dummy." + JavaScriptFileType.INSTANCE.getDefaultExtension(), (FileType)JavaScriptFileType.INSTANCE, (CharSequence)text);
    }

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "showHint"));
        }
        if (!this.myNeedHint) {
            return false;
        }
        PsiElement element = this.myPointer.getElement();
        if (element == null || !element.isValid()) {
            return false;
        }
        Project project = editor.getProject();
        if (project == null) {
            return false;
        }
        PsiReference reference = element.getReference();
        if (reference == null) {
            return false;
        }
        PsiElement referenceElement = reference.getElement();
        if (referenceElement == null) {
            return false;
        }
        TextRange rangeInElement = reference.getRangeInElement();
        int elOffset = referenceElement.getTextOffset();
        TextRange range = new TextRange(elOffset + rangeInElement.getStartOffset(), elOffset + rangeInElement.getEndOffset());
        String message = ShowAutoImportPass.getMessage((boolean)false, (String)this.getVarName());
        HintManager.getInstance().showQuestionHint(editor, message, range.getStartOffset(), range.getEndOffset(), () -> {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "lambda$showHint$3"));
            }
            if (project.isDisposed() || !element.isValid()) {
                return false;
            }
            TransactionGuard.submitTransaction((Disposable)project, () -> {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "lambda$null$2"));
                }
                Runnable runnable = () -> {
                    if (editor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "lambda$null$1"));
                    }
                    WriteAction.run(() -> {
                        if (editor == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "lambda$null$0"));
                        }
                        this.invoke(project, editor, element.getContainingFile());
                    });
                };
                CommandProcessor.getInstance().executeCommand(project, runnable, this.getClass().getName(), (Object)this);
                this.myNeedHint = false;
            });
            return true;
        });
        return true;
    }

    public String getPath() {
        return this.myFixDescriptor.getFromPath();
    }

    @Override
    public String getVarName() {
        if (this.myFixDescriptor.getTail() != null) {
            String[] tail = this.myFixDescriptor.getTail();
            return tail[tail.length - 1];
        }
        return this.myFixDescriptor.getFirstWordInFile();
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "getName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/modules/ImportCommonJSModuleFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        if (this.isAcceptableReference(element)) {
            this.invokeAction(element, null);
        }
    }
}

