/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.javascript.nodejs.library.NodeJsCoreLibraryManager;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.InstallNodeModuleAddToDependenciesQuickFix;
import com.intellij.lang.javascript.modules.InstallNodeModuleAddToDevDependenciesQuickFix;
import com.intellij.lang.javascript.modules.InstallNodeModuleQuickFix;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.modules.PackageJsonDocumentDependencies;
import com.intellij.lang.javascript.modules.RecordModuleIntoDepPackageJsonQuickFix;
import com.intellij.lang.javascript.modules.RecordModuleIntoDevPackageJsonQuickFix;
import com.intellij.lang.javascript.modules.RunNpmUpdateQuickFix;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmUsedModulesInstalledInspection
extends JSInspection {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.modules.NpmUsedModulesInstalledInspection");
    public static final String[] NODE_MODULES = new String[]{"node_modules"};
    private final PackageJsonDocumentDependencies myPackageJsonDocumentDependencies = PackageJsonDocumentDependencies.getInstance();

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, final LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitES6FromClause(ES6FromClause fromClause) {
                if (!DialectDetector.isJavaScript((PsiElement)fromClause)) {
                    return;
                }
                Convertor resolver = moduleRoot -> {
                    PsiReference[] references;
                    for (PsiReference reference : references = fromClause.getReferences()) {
                        PsiElement resolve = reference.resolve();
                        if (resolve == null || !resolve.isValid() || resolve.getContainingFile() == null) continue;
                        return resolve.getContainingFile().getVirtualFile();
                    }
                    return null;
                };
                NpmUsedModulesInstalledInspection.this.check((PsiElement)fromClause, fromClause.getReferenceText(), holder, (Convertor<VirtualFile, VirtualFile>)resolver, (Getter<InstallNodeModuleQuickFix.ModuleElement<? extends JSElement>>)() -> new InstallNodeModuleQuickFix.ES6FromClauseModuleElement(fromClause));
            }

            public void visitJSCallExpression(JSCallExpression call) {
                if (!DialectDetector.isJavaScript((PsiElement)call.getContainingFile())) {
                    return;
                }
                Project project = session.getFile().getProject();
                if (!call.isRequireCall()) {
                    return;
                }
                if (!NodeJsCoreLibraryManager.isAssociatedWithNodeCoreLibrary(session.getFile())) {
                    return;
                }
                JSExpression argument = call.getArguments()[0];
                if (argument instanceof JSLiteralExpression) {
                    LOG.debug("Module " + argument.getText() + " does not have a reference");
                    String referenceText = StringUtil.unquoteString((String)argument.getText());
                    Convertor resolver = moduleRoot -> {
                        String[] split;
                        ResolveResult[] resolve;
                        JSModuleBaseReference reference = this.getNodeModuleReference(argument);
                        if (reference == null) {
                            return null;
                        }
                        Object list = reference instanceof PsiPolyVariantReference ? ((PsiPolyVariantReference)reference).multiResolve(false) : ((resolve = ((PsiReference)reference).resolve()) != null ? new ResolveResult[]{new PsiElementResolveResult((PsiElement)resolve)} : null);
                        if (list != null) {
                            for (ResolveResult result : list) {
                                PsiFileSystemItem psiFile;
                                if (result == null || !result.isValidResult() || result.getElement() == null || !result.getElement().isValid()) continue;
                                PsiElement resolve2 = result.getElement();
                                Object object = psiFile = resolve2 instanceof PsiFileSystemItem ? (PsiFileSystemItem)resolve2 : resolve2.getContainingFile();
                                if (psiFile.isDirectory() || !DialectDetector.JAVASCRIPT_FILE_TYPES.contains(psiFile.getVirtualFile().getFileType()) && !TypeScriptUtil.isDefinitionFile(psiFile.getVirtualFile()) || NodeModuleUtil.canBeRequired(project, moduleRoot, (PsiFile)psiFile, true) == null) continue;
                                return psiFile.getVirtualFile();
                            }
                        }
                        String name = (split = referenceText.replace("\\", "/").split("/")).length == 0 ? referenceText : split[0];
                        VirtualFile nm = moduleRoot.findChild("node_modules");
                        if (nm != null) {
                            return nm.findChild(name);
                        }
                        return null;
                    };
                    NpmUsedModulesInstalledInspection.this.check((PsiElement)argument, referenceText, holder, (Convertor<VirtualFile, VirtualFile>)resolver, (Getter<InstallNodeModuleQuickFix.ModuleElement<? extends JSElement>>)() -> new InstallNodeModuleQuickFix.RequireModuleElement((JSLiteralExpression)argument));
                }
            }

            private JSModuleBaseReference getNodeModuleReference(JSExpression argument) {
                PsiReference[] references;
                for (PsiReference reference : references = argument.getReferences()) {
                    if (!(reference instanceof JSModuleBaseReference)) continue;
                    return (JSModuleBaseReference)reference;
                }
                return null;
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Check require() reference" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection", "getDisplayName"));
        }
        return "Check require() reference";
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    private void check(@Nullable PsiElement element, @Nullable String referenceText, ProblemsHolder holder, @NotNull Convertor<VirtualFile, VirtualFile> resolver, @NotNull Getter<InstallNodeModuleQuickFix.ModuleElement<? extends JSElement>> pointerCreator) {
        ASTNode[] children;
        PsiElement elementToHoldFix;
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection", "check"));
        }
        if (pointerCreator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointerCreator", "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection", "check"));
        }
        if (referenceText == null || element == null) {
            return;
        }
        String moduleName = NpmUsedModulesInstalledInspection.getModuleName(referenceText = referenceText.trim());
        if (NpmUsedModulesInstalledInspection.notInstallableModuleName(moduleName)) {
            return;
        }
        if (NodeJsCoreLibraryManager.isCoreModuleName(moduleName)) {
            return;
        }
        VirtualFile coreModule = NodeJsCoreLibraryManager.getInstance(holder.getProject()).findCoreModuleFileByName(moduleName);
        if (coreModule != null) {
            return;
        }
        if (this.myPackageJsonDocumentDependencies.isBeingInstalled(moduleName)) {
            return;
        }
        Collection packageJsonFiles = FilenameIndex.getVirtualFilesByName((Project)element.getProject(), (String)"package.json", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)element.getProject()));
        packageJsonFiles = ContainerUtil.filter((Collection)packageJsonFiles, file -> !JSLibraryUtil.isProbableLibraryFile(file));
        boolean inPackageJson = false;
        InstallationDetector installationDetector = new InstallationDetector(element.getProject(), resolver);
        if (!packageJsonFiles.isEmpty()) {
            for (VirtualFile packageJsonFile : packageJsonFiles) {
                VirtualFile moduleRoot = packageJsonFile.getParent();
                if (moduleRoot == null || !packageJsonFile.isValid()) continue;
                boolean notInPackageJson = NpmUsedModulesInstalledInspection.moduleNotInPackageJson(holder.getProject(), moduleName, packageJsonFile);
                if (!notInPackageJson) {
                    inPackageJson = true;
                }
                installationDetector.accept(moduleRoot);
                if (!inPackageJson || !installationDetector.isInstalledMaybeMultiple()) continue;
                return;
            }
        }
        if (!installationDetector.isInstalledMaybeMultiple() && packageJsonFiles.isEmpty()) {
            installationDetector.accept(element.getProject().getBaseDir());
        }
        if ((elementToHoldFix = element) instanceof ES6FromClause && (children = elementToHoldFix.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.STRING_LITERAL}))).length == 1) {
            elementToHoldFix = children[0].getPsi();
        }
        InstallNodeModuleQuickFix.ModuleElement moduleElement = (InstallNodeModuleQuickFix.ModuleElement)pointerCreator.get();
        if (installationDetector.isInstalledMaybeMultiple()) {
            if (!inPackageJson && installationDetector.isLibraryResolveOnly()) {
                holder.registerProblem(elementToHoldFix, JSBundle.message((String)"npm.modules.inspection.content.of.require.not.in.dependencies.warning", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RecordModuleIntoDepPackageJsonQuickFix(moduleElement, packageJsonFiles, installationDetector.getNodeModules()), new RecordModuleIntoDevPackageJsonQuickFix(moduleElement, packageJsonFiles, installationDetector.getNodeModules())});
            }
        } else {
            ArrayList<InstallNodeModuleQuickFix> fixes = new ArrayList<InstallNodeModuleQuickFix>();
            if (!inPackageJson) {
                fixes.add(new InstallNodeModuleAddToDependenciesQuickFix(moduleElement, packageJsonFiles));
                fixes.add(new InstallNodeModuleAddToDevDependenciesQuickFix(moduleElement, packageJsonFiles));
            }
            fixes.add(new InstallNodeModuleQuickFix(moduleElement, packageJsonFiles));
            if (!packageJsonFiles.isEmpty()) {
                fixes.add(new RunNpmUpdateQuickFix(moduleElement, packageJsonFiles));
            }
            holder.registerProblem(elementToHoldFix, JSBundle.message((String)"npm.modules.inspection.content.of.require.module.not.installed.warning", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fixes.toArray(new LocalQuickFix[fixes.size()]));
        }
    }

    @NotNull
    public static String getModuleName(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection", "getModuleName"));
        }
        if (NpmUsedModulesInstalledInspection.startWithLocalPrefix(text)) {
            String string = text;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection", "getModuleName"));
            }
            return string;
        }
        String path = StringUtil.unquoteString((String)text);
        String[] strings = path.split("/");
        if (strings.length > 1) {
            if (strings[0].startsWith("@")) {
                String string = strings[0] + "/" + strings[1];
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection", "getModuleName"));
                }
                return string;
            }
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection", "getModuleName"));
            }
            return "";
        }
        String string = strings.length == 0 ? "" : strings[0];
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection", "getModuleName"));
        }
        return string;
    }

    private static boolean startWithLocalPrefix(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection", "startWithLocalPrefix"));
        }
        return text.startsWith("./") || text.startsWith("../");
    }

    public static boolean notInstallableModuleName(@NotNull String moduleName) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection", "notInstallableModuleName"));
        }
        if (NpmUsedModulesInstalledInspection.startWithLocalPrefix(moduleName)) {
            return true;
        }
        if (StringUtil.isEmptyOrSpaces((String)moduleName)) {
            return true;
        }
        boolean haveNamePartInWord = false;
        for (int i = 0; i < moduleName.length(); ++i) {
            char ch = moduleName.charAt(i);
            if (ch == '@' && i > 0) {
                return true;
            }
            boolean namePart = Character.isLetterOrDigit(ch) || ch == '_' || ch == '-' || ch == '@';
            haveNamePartInWord |= namePart;
            if (namePart || ch == '.' || ch == '/') continue;
            return true;
        }
        return !haveNamePartInWord;
    }

    public static boolean moduleNotInPackageJson(Project project, String name, VirtualFile packageJsonFile) {
        PackageJsonDocumentDependencies.Dependencies dependencies = PackageJsonDocumentDependencies.getInstance().getForFile(project, packageJsonFile);
        if (dependencies != null) {
            return !dependencies.getDependencies().containsKey(name) && !dependencies.getDevDependencies().containsKey(name) && !dependencies.getOptionalDependencies().containsKey(name);
        }
        return false;
    }

    private static class InstallationDetector {
        private boolean myIsLibraryResolveOnly;
        private boolean myMultipleInstallations;
        private VirtualFile myNodeModules;
        @NotNull
        private final Project myProject;
        @NotNull
        private final Convertor<VirtualFile, VirtualFile> myResolver;

        public InstallationDetector(@NotNull Project project, @NotNull Convertor<VirtualFile, VirtualFile> resolver) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection$InstallationDetector", "<init>"));
            }
            if (resolver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection$InstallationDetector", "<init>"));
            }
            this.myIsLibraryResolveOnly = true;
            this.myProject = project;
            this.myResolver = resolver;
        }

        public void accept(@NotNull VirtualFile packageJsonParent) {
            if (packageJsonParent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJsonParent", "com/intellij/lang/javascript/modules/NpmUsedModulesInstalledInspection$InstallationDetector", "accept"));
            }
            VirtualFile resolveFile = (VirtualFile)this.myResolver.convert((Object)packageJsonParent);
            if (resolveFile != null) {
                this.myIsLibraryResolveOnly &= JSLibraryUtil.hasDirectoryInPath(resolveFile, NODE_MODULES, NodeModuleUtil.findParentContentRoot(this.myProject, resolveFile));
                VirtualFile folder = JSLibraryUtil.getTopLibraryFolder(resolveFile, NODE_MODULES[0], null);
                if (folder != null) {
                    if (!this.myMultipleInstallations && this.myNodeModules == null) {
                        this.myNodeModules = folder.getParent();
                    } else {
                        this.myMultipleInstallations = true;
                        this.myNodeModules = null;
                    }
                }
            }
        }

        public boolean isLibraryResolveOnly() {
            return this.myIsLibraryResolveOnly;
        }

        public boolean isInstalledMaybeMultiple() {
            return this.myNodeModules != null || this.myMultipleInstallations;
        }

        public boolean isInstalled() {
            return this.myNodeModules != null;
        }

        public boolean isMultipleInstallations() {
            return this.myMultipleInstallations;
        }

        public VirtualFile getNodeModules() {
            return this.myNodeModules;
        }
    }
}

