/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.nashorn.library;

import com.intellij.lang.javascript.library.JSPredefinedLibraryProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.net.URL;
import org.jetbrains.annotations.NotNull;

public class NashornJSLibraryProvider
extends JSPredefinedLibraryProvider {
    public static final String LIBRARY_NAME = "Nashorn";
    private static final String NASHORN_FILE_NAME = "Nashorn.js";
    private static final AtomicNotNullLazyValue<VirtualFile> LIBRARY_FILE = new AtomicNotNullLazyValue<VirtualFile>(){

        @NotNull
        protected VirtualFile compute() {
            URL libFileUrl = NashornJSLibraryProvider.class.getResource(NashornJSLibraryProvider.NASHORN_FILE_NAME);
            assert (libFileUrl != null) : "Can not find Nashorn.js, the installation is possibly broken.";
            VirtualFile virtualFile = VfsUtil.findFileByURL((URL)libFileUrl);
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/nashorn/library/NashornJSLibraryProvider$1", "compute"));
            }
            return virtualFile;
        }
    };

    @Override
    @NotNull
    public ScriptingLibraryModel[] getPredefinedLibraries(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/nashorn/library/NashornJSLibraryProvider", "getPredefinedLibraries"));
        }
        VirtualFile libFile = (VirtualFile)LIBRARY_FILE.getValue();
        ScriptingLibraryModel libraryModel = ScriptingLibraryModel.createPredefinedLibrary((String)LIBRARY_NAME, (VirtualFile[])new VirtualFile[]{libFile}, (boolean)false);
        ScriptingLibraryModel[] scriptingLibraryModelArray = new ScriptingLibraryModel[]{libraryModel};
        if (scriptingLibraryModelArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/nashorn/library/NashornJSLibraryProvider", "getPredefinedLibraries"));
        }
        return scriptingLibraryModelArray;
    }
}

