/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.nashorn.resolve;

import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.annotations.NotNull;

public class NashornJSQualifiedItemProcessor<T extends ResultSink>
extends QualifiedItemProcessor<T> {
    public NashornJSQualifiedItemProcessor(T sink, PsiFile containingFile) {
        super(sink, containingFile);
    }

    @Override
    public void process(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext, PsiElement source) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/nashorn/resolve/NashornJSQualifiedItemProcessor", "process"));
        }
        if (evaluateContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "com/intellij/lang/javascript/nashorn/resolve/NashornJSQualifiedItemProcessor", "process"));
        }
        PsiElement element = type.getSource().getSourceElement();
        if (element instanceof PsiClass || element instanceof PsiPackage) {
            element.processDeclarations((PsiScopeProcessor)this, ResolveState.initial(), null, this.place);
            if (element instanceof PsiClass) {
                boolean isSetter = this.place instanceof JSDefinitionExpression;
                String qualifiedName = ((PsiClass)element).getQualifiedName();
                JSQualifiedNameImpl ns = qualifiedName != null ? JSQualifiedNameImpl.fromQualifiedName(qualifiedName) : null;
                for (PsiMethod method : ((PsiClass)element).getAllMethods()) {
                    String name = method.getName();
                    if (!name.startsWith(isSetter ? "set" : "get") || method.getParameterList().getParametersCount() != (isSetter ? 1 : 0)) continue;
                    String propertyName = StringUtil.decapitalize((String)name.substring(3));
                    this.execute((PsiElement)new JSImplicitElementImpl(propertyName, ns, (PsiElement)method), ResolveState.initial());
                }
            }
            this.resolved = QualifiedItemProcessor.TypeResolveState.Resolved;
        }
        super.process(type, evaluateContext, source);
    }
}

