/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptVariableImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSParameterImpl;
import com.intellij.lang.javascript.psi.stubs.JSParameterStub;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSDestructuringTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.Segment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptParameterImpl
extends JSParameterImpl {
    public TypeScriptParameterImpl(ASTNode node) {
        super(node);
    }

    @Override
    public boolean isConst() {
        JSAttributeList list;
        if (TypeScriptPsiUtil.isFieldParameter(this) && (list = this.getAttributeList()) != null) {
            return list.hasModifier(JSAttributeList.ModifierType.READONLY);
        }
        return super.isConst();
    }

    public TypeScriptParameterImpl(JSParameterStub stub) {
        super(stub, TypeScriptElementTypes.TYPESCRIPT_PARAMETER);
    }

    protected JSType doGetDeclarationTypeStubSafe() {
        JSType type = TypeScriptPsiUtil.getTypeFromDeclaration(this);
        if (type == null) {
            return null;
        }
        boolean isRest = this.isRest();
        if (isRest) {
            JSGenericTypeImpl genericType;
            if (type instanceof JSArrayTypeImpl) {
                type = ((JSArrayTypeImpl)type).getType();
            } else if (type instanceof JSGenericTypeImpl && JSArrayTypeImpl.isGenericArray(genericType = (JSGenericTypeImpl)type)) {
                type = (JSType)ContainerUtil.getFirstItem(genericType.getArguments());
            }
        }
        return type;
    }

    @Override
    @Nullable
    protected JSType doGetType() {
        JSType type = this.doGetDeclarationTypeStubSafe();
        if (type != null) {
            return type;
        }
        PsiElement parent = this.getParent();
        if (JSDestructuringUtil.isDestructuring(parent)) {
            return new JSDestructuringTypeImpl((Segment)this.getTextRange(), JSTypeSourceFactory.createTypeSource((PsiElement)this, true));
        }
        JSExpression initializer = this.getInitializer();
        if (initializer != null) {
            type = new JSTypeofTypeImpl(initializer, JSTypeSourceFactory.createTypeSource((PsiElement)this, true));
        }
        return type;
    }

    @Override
    public boolean isOptional() {
        JSParameterStub parameterStub = (JSParameterStub)this.getGreenStub();
        if (parameterStub != null) {
            return parameterStub.isOptional();
        }
        if (this.getNode().findChildByType(JSTokenTypes.QUEST) != null) {
            return true;
        }
        if (this.getInitializer() == null) {
            return false;
        }
        return this.isOptionalForParameterWithInitializer();
    }

    private boolean isOptionalForParameterWithInitializer() {
        JSFunction function = this.getDeclaringFunction();
        if (function == null) {
            return true;
        }
        boolean checkCurrent = false;
        for (JSParameterListElement parameter : function.getParameters()) {
            if (parameter == this) {
                checkCurrent = true;
                continue;
            }
            if (!checkCurrent) continue;
            if (parameter.isOptional() || parameter.isRest()) break;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    protected JSType doGetStubType(JSParameterStub stub) {
        String typeText = stub.getTypeString();
        if (typeText == null) {
            return this.doGetDeclarationTypeStubSafe();
        }
        return TypeScriptVariableImpl.getTypeFromStubString(this, stub, typeText);
    }

    @Override
    @Deprecated
    @Nullable
    public String getTypeString() {
        JSType type = this.getType();
        return type == null ? null : type.getTypeText(JSType.TypeTextFormat.SERIALIZED);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        JSClass parentClass;
        if (TypeScriptPsiUtil.isFieldParameter(this) && (parentClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)this, JSClass.class)) != null) {
            JSAttributeList.AccessType accessType = this.getAccessType();
            Object object = accessType == JSAttributeList.AccessType.PRIVATE ? new LocalSearchScope((PsiElement)parentClass) : parentClass.getUseScope();
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptParameterImpl", "getUseScope"));
            }
            return object;
        }
        SearchScope searchScope = super.getUseScope();
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptParameterImpl", "getUseScope"));
        }
        return searchScope;
    }

    @Override
    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList attributeList = this.getAttributeList();
        if (attributeList != null) {
            JSAttributeList.AccessType type = attributeList.getExplicitAccessType();
            if (type != null) {
                JSAttributeList.AccessType accessType = type;
                if (accessType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptParameterImpl", "getAccessType"));
                }
                return accessType;
            }
            if (TypeScriptPsiUtil.isFieldParameter(this)) {
                JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PUBLIC;
                if (accessType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptParameterImpl", "getAccessType"));
                }
                return accessType;
            }
        }
        JSAttributeList.AccessType accessType = super.getAccessType();
        if (accessType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptParameterImpl", "getAccessType"));
        }
        return accessType;
    }

    public TypeScriptType getTypeElement() {
        return TypeScriptPsiUtil.getStubOrPsiTypeElement(this);
    }

    @Override
    protected boolean isTypeExplicitlyDeclared() {
        return true;
    }
}

