/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.impl.JSExpressionImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class JSIndexedPropertyAccessExpressionImpl
extends JSExpressionImpl
implements JSIndexedPropertyAccessExpression {
    public JSIndexedPropertyAccessExpressionImpl(ASTNode node) {
        super(node);
    }

    public JSExpression getQualifier() {
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType type = child.getElementType();
            if (type == JSTokenTypes.LBRACKET) {
                return null;
            }
            if (!JSElementTypes.EXPRESSIONS.contains(type)) continue;
            return (JSExpression)child.getPsi();
        }
        return null;
    }

    public JSExpression getIndexExpression() {
        ASTNode expression = JSIndexedPropertyAccessExpressionImpl.getIndexExpression(this.getNode());
        return expression != null ? (JSExpression)expression.getPsi() : null;
    }

    public static ASTNode getIndexExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/psi/impl/JSIndexedPropertyAccessExpressionImpl", "getIndexExpression"));
        }
        assert (node.getElementType() == JSElementTypes.INDEXED_PROPERTY_ACCESS_EXPRESSION);
        boolean bracketPassed = false;
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType type = child.getElementType();
            if (type == JSTokenTypes.LBRACKET) {
                bracketPassed = true;
            }
            if (!bracketPassed || !JSElementTypes.EXPRESSIONS.contains(type)) continue;
            return child;
        }
        return null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSIndexedPropertyAccessExpressionImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSIndexedPropertyAccessExpression((JSIndexedPropertyAccessExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }
}

