/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.index.JSImplicitElementsIndex;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSContextLevel;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTaggedResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSGlobalSymbolIndex;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSNonGlobalSymbolIndex;
import com.intellij.lang.javascript.psi.stubs.JSSymbolIndex2;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.statistics.JSResolveStatisticsCollector;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IdIterator;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSReferenceExpressionResolver
implements ResolveCache.PolyVariantResolver<JSReferenceExpressionImpl> {
    private static final Key<CachedValue<Map<String, ResolveResult[]>>> cachedTopResolveKey = Key.create((String)"top.level.cached.results");
    private static final int MAX_FILES_TO_PROCESS = Integer.valueOf(System.getProperty("js.max.files.to.process", "10"));
    private static final int MAX_RESULTS_COUNT_TO_KEEP = Integer.valueOf(System.getProperty("js.max.results.count.to.keep", "20"));
    protected final JSReferenceExpressionImpl myRef;
    protected final PsiElement myParent;
    protected final PsiFile myContainingFile;
    @Nullable
    protected final String myReferencedName;
    protected final JSExpression myQualifier;
    protected final boolean myLocalResolve;
    private final boolean myIgnorePerformanceLimits;

    public JSReferenceExpressionResolver(@NotNull JSReferenceExpressionImpl expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/psi/resolve/JSReferenceExpressionResolver", "<init>"));
        }
        this(expression, false);
    }

    public JSReferenceExpressionResolver(@NotNull JSReferenceExpressionImpl expression, boolean ignorePerformanceLimits) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/psi/resolve/JSReferenceExpressionResolver", "<init>"));
        }
        this.myRef = expression;
        this.myContainingFile = expression.getContainingFile();
        this.myReferencedName = this.adjustReferencedName(this.myRef);
        this.myParent = this.myRef.getParent();
        this.myQualifier = this.myRef.getResolveQualifier();
        this.myLocalResolve = JSReferenceExpressionImpl.isLocalResolveQualifier(this.myQualifier);
        this.myIgnorePerformanceLimits = ignorePerformanceLimits;
    }

    @NotNull
    public ResolveResult[] resolve(@NotNull JSReferenceExpressionImpl expression, boolean incompleteCode) {
        ResolveResult[] results;
        SinkResolveProcessor<ResolveResultSink> localProcessor;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/psi/resolve/JSReferenceExpressionResolver", "resolve"));
        }
        if (this.myReferencedName == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSReferenceExpressionResolver", "resolve"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        boolean localResultFound = false;
        PsiElement currentParent = JSResolveUtil.getTopReferenceParent(this.myParent);
        if (JSResolveUtil.isSelfReference(currentParent, (PsiElement)this.myRef)) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new JSResolveResult(currentParent)};
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSReferenceExpressionResolver", "resolve"));
            }
            return resolveResultArray;
        }
        ResolveResult[] resultsFromProviders = this.resolveFromProviders();
        if (resultsFromProviders != null) {
            if (resultsFromProviders == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSReferenceExpressionResolver", "resolve"));
            }
            return resultsFromProviders;
        }
        if (this.myLocalResolve) {
            localProcessor = this.createLocalResolveProcessor();
            localProcessor.setToProcessHierarchy(true);
            JSReferenceExpressionImpl.doProcessLocalDeclarations((PsiElement)this.myRef, this.myQualifier, localProcessor, false, false, null);
            PsiElement jsElement = localProcessor.getResult();
            if (!(jsElement == null || jsElement instanceof JSImplicitElement && ((JSImplicitElement)jsElement).hasMinorImportance())) {
                ResolveResult[] results2 = localProcessor.getResultsAsResolveResults();
                JSResolveStatisticsCollector.getInstance().consume((Object)JSResolveStatisticsCollector.ResolveSource.LOCAL, (Object)results2.length);
                if (results2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSReferenceExpressionResolver", "resolve"));
                }
                return results2;
            }
            localResultFound = jsElement != null;
        } else {
            QualifiedItemProcessor<ResolveResultSink> processor = this.createQualifiedItemProcessor();
            processor.setTypeContext(true);
            JSTypeEvaluator.evaluateTypes(this.myQualifier, this.myContainingFile, processor, JSEvaluateContext.JSEvaluationPlace.REFERENCE_EXPRESSION);
            ResolveResultSink resultSink = (ResolveResultSink)processor.getResultSink();
            if (processor.resolved == QualifiedItemProcessor.TypeResolveState.Resolved || processor.resolved == QualifiedItemProcessor.TypeResolveState.Undefined || resultSink.getCompleteResult() != null) {
                ResolveResult[] results3 = processor.getResultsAsResolveResults();
                JSResolveStatisticsCollector.getInstance().consume((Object)JSResolveStatisticsCollector.ResolveSource.QUALIFIED, (Object)results3.length);
                if (results3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSReferenceExpressionResolver", "resolve"));
                }
                return results3;
            }
            localProcessor = processor;
        }
        Map<String, ResolveResult[]> cachedResultsMap = null;
        if (!(this.myQualifier != null || localResultFound || this.myParent instanceof JSDefinitionExpression && !JSResolveUtil.isEcmaScript5((PsiElement)this.myRef) || (results = (cachedResultsMap = JSReferenceExpressionResolver.getCachedTopLevelResultsMap(this.myContainingFile)).get(this.myReferencedName)) == null)) {
            if (results == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSReferenceExpressionResolver", "resolve"));
            }
            return results;
        }
        results = this.resolveFromIndices(localProcessor);
        if (results.length == 0 && localProcessor.isEncounteredXmlLiteral()) {
            ResolveResult[] resolveResultArray = this.dummyResult(this.myRef);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSReferenceExpressionResolver", "resolve"));
            }
            return resolveResultArray;
        }
        if (cachedResultsMap != null) {
            cachedResultsMap.put(this.myReferencedName, results);
        }
        if (results == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSReferenceExpressionResolver", "resolve"));
        }
        return results;
    }

    @Nullable
    protected ResolveResult[] resolveFromProviders() {
        for (PsiReference reference : ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this.myRef)) {
            if (reference instanceof PsiPolyVariantReference) {
                ResolveResult[] results = ((PsiPolyVariantReference)reference).multiResolve(false);
                if (results.length <= 0) continue;
                return results;
            }
            PsiElement resolve = reference.resolve();
            if (resolve == null) continue;
            return new ResolveResult[]{new JSResolveResult(resolve)};
        }
        return null;
    }

    @NotNull
    protected SinkResolveProcessor<ResolveResultSink> createLocalResolveProcessor() {
        SinkResolveProcessor<ResolveResultSink> sinkResolveProcessor = new SinkResolveProcessor<ResolveResultSink>(this.myReferencedName, (PsiElement)this.myRef, new ResolveResultSink((PsiElement)this.myRef, this.myReferencedName));
        if (sinkResolveProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSReferenceExpressionResolver", "createLocalResolveProcessor"));
        }
        return sinkResolveProcessor;
    }

    @NotNull
    protected QualifiedItemProcessor<ResolveResultSink> createQualifiedItemProcessor() {
        QualifiedItemProcessor<ResolveResultSink> qualifiedItemProcessor = JSDialectSpecificHandlersFactory.forElement((PsiElement)this.myRef).createQualifiedItemProcessor((PsiElement)this.myRef, this.myReferencedName);
        if (qualifiedItemProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSReferenceExpressionResolver", "createQualifiedItemProcessor"));
        }
        return qualifiedItemProcessor;
    }

    protected ResolveResult[] resolveFromIndices(@NotNull SinkResolveProcessor<ResolveResultSink> localProcessor) {
        if (localProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localProcessor", "com/intellij/lang/javascript/psi/resolve/JSReferenceExpressionResolver", "resolveFromIndices"));
        }
        assert (this.myReferencedName != null);
        WalkUpResolveProcessor processor = new WalkUpResolveProcessor(this.myReferencedName, this.myContainingFile, (PsiElement)this.myRef);
        PsiElement parent = this.myParent;
        while (parent instanceof JSObjectLiteralExpression || parent instanceof JSArrayLiteralExpression) {
            parent = parent.getParent();
        }
        boolean inDefinition = parent instanceof JSDefinitionExpression;
        this.prepareProcessor(processor, localProcessor);
        JSResolveUtil.tryProcessXmlFileImplicitElements((PsiElement)this.myRef, processor);
        JSResolveUtil.tryProcessAllElementsInInjectedContext(this.myContainingFile, (Processor<JSPsiElementBase>)((Processor)element -> {
            if (this.myReferencedName.equals(element.getName())) {
                processor.doQualifiedCheck((JSPsiElementBase)element);
            }
            return true;
        }));
        JSReferenceExpressionResolver.processAllSymbols(processor, this.myIgnorePerformanceLimits);
        ResolveResult[] results = this.getResultsFromProcessor(processor);
        JSResolveStatisticsCollector.getInstance().consume((Object)JSResolveStatisticsCollector.ResolveSource.SYMBOL, (Object)results.length);
        if (results.length == 0 && inDefinition) {
            return this.getResultsForDefinition();
        }
        return this.myIgnorePerformanceLimits || results.length <= MAX_RESULTS_COUNT_TO_KEEP ? results : JSResolveResult.TOO_MANY_CANDIDATES;
    }

    public static void processAllSymbols(WalkUpResolveProcessor processor) {
        JSReferenceExpressionResolver.processAllSymbols(processor, false);
    }

    public static void processAllSymbols(WalkUpResolveProcessor processor, boolean ignorePerformanceLimit) {
        PsiFile file = processor.getBaseFile();
        GlobalSearchScope allScope = JSResolveUtil.getResolveScope(processor.getContext());
        Project project = file.getProject();
        String name = processor.getRequiredName();
        JSSymbolCollector collector = new JSSymbolCollector();
        for (JSContextLevel level : processor.getTypeInfo().myContextLevels) {
            JSNamespace namespace = level.myNamespace;
            JSQualifiedName ns = namespace.getQualifiedName();
            String qName = ns != null ? ns.getQualifiedName() + "." + name : name;
            GlobalSearchScope scope = level.adjustScope(allScope);
            PsiFile fileToIncludeLocal = level.myJSModule != null ? level.myJSModule : file;
            JSClassResolver.getInstance().processElementsByQNameIncludingImplicit(qName, scope, fileToIncludeLocal, collector);
            JSResolveStatisticsCollector.getInstance().consume((Object)JSResolveStatisticsCollector.ResolveSource.PROCESSED_BY_QNAME, (Object)collector.myCollectedElements.size());
        }
        JSReferenceExpressionResolver.checkElements(processor, collector);
        List<JSTaggedResolveResult> resultsWithCompleteMatches = processor.getTaggedResolveResults();
        boolean hasValidResult = false;
        for (JSTaggedResolveResult completeMatchResult : resultsWithCompleteMatches) {
            if (!completeMatchResult.result.isValidResult()) continue;
            hasValidResult = true;
            break;
        }
        if (!hasValidResult && processor.myAllowPartialResults) {
            StubIndexKey<String, JSElement> indexKey;
            StubIndexKey<String, JSElement> stubIndexKey = processor.getTypeInfo().isGlobalStatusHint() ? JSGlobalSymbolIndex.KEY : (indexKey = processor.getTypeInfo().isNonGlobalStatusHint() ? JSNonGlobalSymbolIndex.KEY : JSSymbolIndex2.KEY);
            if (ignorePerformanceLimit || JSReferenceExpressionResolver.cheapEnoughToProcess(allScope, project, name, indexKey)) {
                JSClassResolver.processElementsByNameIncludingImplicit(name, allScope, false, indexKey, collector);
                JSResolveStatisticsCollector.getInstance().consume((Object)JSResolveStatisticsCollector.ResolveSource.PROCESSED_BY_NAME, (Object)collector.myCollectedElements.size());
                JSReferenceExpressionResolver.checkElements(processor, collector);
            } else {
                processor.setTooManyCandidates();
            }
        }
        FileBasedIndex.ValueProcessor implicitElementsProcessor = (virtualFile, value) -> {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
            if (psiFile != null && processor.acceptsFile(psiFile)) {
                for (JSImplicitElementsIndex.JSElementProxy proxy : value) {
                    processor.doQualifiedCheck((JSPsiElementBase)proxy.toOffsetBasedImplicitElement(psiFile));
                }
            }
            return true;
        };
        FileBasedIndex.getInstance().processValues(JSImplicitElementsIndex.INDEX_ID, (Object)name, null, implicitElementsProcessor, allScope);
    }

    private static boolean cheapEnoughToProcess(GlobalSearchScope allScope, Project project, String name, StubIndexKey<String, JSElement> indexKey) {
        IdIterator ids = StubIndex.getInstance().getContainingIds(indexKey, (Object)name, project, allScope);
        return ids.size() <= MAX_FILES_TO_PROCESS;
    }

    private static void checkElements(WalkUpResolveProcessor processor, JSSymbolCollector collector) {
        Set<JSElement> elementsToProcess = collector.prepareElementsForChecking();
        for (JSElement element : elementsToProcess) {
            ProgressManager.checkCanceled();
            if (!processor.acceptsFile(element.getContainingFile())) continue;
            if (element instanceof JSQualifiedNamedElement || element instanceof JSImplicitElement) {
                processor.doQualifiedCheck((JSPsiElementBase)element);
                continue;
            }
            processor.doUnqualifiedCheck((PsiElement)element);
        }
    }

    protected ResolveResult[] getResultsFromProcessor(WalkUpResolveProcessor processor) {
        return processor.getResults();
    }

    @Nullable
    protected String adjustReferencedName(@NotNull JSReferenceExpression ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/lang/javascript/psi/resolve/JSReferenceExpressionResolver", "adjustReferencedName"));
        }
        return ref.getReferenceName();
    }

    protected void prepareProcessor(WalkUpResolveProcessor processor, @NotNull SinkResolveProcessor<ResolveResultSink> localProcessor) {
        if (localProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localProcessor", "com/intellij/lang/javascript/psi/resolve/JSReferenceExpressionResolver", "prepareProcessor"));
        }
        boolean searchForDefinitionDefinition = false;
        boolean inDefinition = false;
        if (this.myParent instanceof JSDefinitionExpression) {
            JSExpression qualifier;
            inDefinition = true;
            if (processor.myContext instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)processor.myContext).getQualifier()) != null && !(qualifier instanceof JSThisExpression)) {
                JSType _qualifierType = JSResolveUtil.getExpressionJSType(qualifier);
                searchForDefinitionDefinition = !JSTypeUtils.isNewPropertiesDefinitionAllowed(_qualifierType) || _qualifierType instanceof JSNamedType && ((JSNamedType)_qualifierType).isStaticOrInstance() == JSContext.INSTANCE;
            }
        } else {
            processor.allowPartialResults();
        }
        if (inDefinition) {
            processor.setAddOnlyCompleteMatches(true);
        }
        processor.setSkipDefinitions(inDefinition && !searchForDefinitionDefinition);
        processor.addLocalResults(localProcessor);
    }

    protected ResolveResult[] getResultsForDefinition() {
        if (this.myQualifier == null && JSResolveUtil.isEcmaScript5((PsiElement)this.myRef)) {
            return ResolveResult.EMPTY_ARRAY;
        }
        return new ResolveResult[]{new JSResolveResult(this.myParent)};
    }

    protected ResolveResult[] dummyResult(JSReferenceExpression expression) {
        return new ResolveResult[]{new JSResolveResult((PsiElement)expression)};
    }

    private static Map<String, ResolveResult[]> getCachedTopLevelResultsMap(PsiFile containingFile) {
        CachedValue cachedResultsMapCachedValue = (CachedValue)containingFile.getUserData(cachedTopResolveKey);
        if (cachedResultsMapCachedValue == null) {
            cachedResultsMapCachedValue = CachedValuesManager.getManager((Project)containingFile.getProject()).createCachedValue(() -> new CachedValueProvider.Result(Collections.synchronizedMap(new THashMap()), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}), false);
            containingFile.putUserData(cachedTopResolveKey, (Object)cachedResultsMapCachedValue);
        }
        Map cachedResultsMap = (Map)cachedResultsMapCachedValue.getValue();
        return cachedResultsMap;
    }

    private static class JSSymbolCollector
    implements Processor<JSPsiElementBase> {
        private Set<JSElement> myCollectedElements = new THashSet();
        private Set<JSElement> myProcessedElements;

        public boolean process(JSPsiElementBase element) {
            if (element instanceof JSFunctionExpression || element instanceof ES6Decorator) {
                return true;
            }
            if (this.myProcessedElements == null || !this.myProcessedElements.contains(element)) {
                this.myCollectedElements.add((JSElement)element);
            }
            return true;
        }

        public Set<JSElement> prepareElementsForChecking() {
            Set<JSElement> elements = this.myCollectedElements;
            this.myCollectedElements = new THashSet();
            if (this.myProcessedElements == null) {
                this.myProcessedElements = elements;
            } else {
                this.myProcessedElements.addAll(elements);
            }
            return elements;
        }
    }
}

