/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.ByteFlagsSerializer;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSImplicitParameterStructure {
    public static final JSImplicitParameterStructure[] EMPTY_ARRAY = new JSImplicitParameterStructure[0];
    private static final BooleanStructureElement OPTIONAL_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement EXPLICITLY_DECLARED_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement REST_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_TYPE_FLAG = new BooleanStructureElement();
    private static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(OPTIONAL_FLAG, EXPLICITLY_DECLARED_FLAG, REST_FLAG, HAS_TYPE_FLAG);
    private static final String NULL_SERIALIZED_NAME = "^null";
    @Nullable
    private final String myName;
    @Nullable
    private final String myTypeString;
    private final byte myFlags;

    public JSImplicitParameterStructure(@Nullable String name, @Nullable String typeString, byte flags) {
        this.myName = name;
        this.myTypeString = typeString;
        this.myFlags = flags;
    }

    public JSImplicitParameterStructure(@Nullable String name, @Nullable String typeString, boolean isOptional, boolean isRest, boolean isTypeExplicitlyDeclared) {
        this.myName = name;
        this.myTypeString = typeString;
        this.myFlags = JSImplicitParameterStructure.calcFlags(isOptional, isRest, isTypeExplicitlyDeclared, typeString);
    }

    public JSImplicitParameterStructure(@NotNull Pair<String, JSParameterTypeDecorator> pair) {
        if (pair == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pair", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitParameterStructure", "<init>"));
        }
        this.myName = (String)pair.first;
        JSParameterTypeDecorator decorator = (JSParameterTypeDecorator)pair.second;
        JSType type = decorator.getType();
        this.myTypeString = type != null ? type.getTypeText(JSType.TypeTextFormat.SERIALIZED) : null;
        this.myFlags = JSImplicitParameterStructure.calcFlags(decorator.isOptional(), decorator.isRest(), decorator.isExplicitlyDeclared(), this.myTypeString);
    }

    private static byte calcFlags(boolean isOptional, boolean isRest, boolean isTypeExplicitlyDeclared, String typeString) {
        byte flags = 0;
        flags = ByteFlagsSerializer.INSTANCE.writeValue(FLAGS_STRUCTURE, HAS_TYPE_FLAG, typeString != null, flags);
        flags = ByteFlagsSerializer.INSTANCE.writeValue(FLAGS_STRUCTURE, OPTIONAL_FLAG, isOptional, flags);
        flags = ByteFlagsSerializer.INSTANCE.writeValue(FLAGS_STRUCTURE, EXPLICITLY_DECLARED_FLAG, isTypeExplicitlyDeclared, flags);
        flags = ByteFlagsSerializer.INSTANCE.writeValue(FLAGS_STRUCTURE, REST_FLAG, isRest, flags);
        return flags;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    @Nullable
    public String getTypeString() {
        return this.myTypeString;
    }

    public boolean isOptional() {
        return ByteFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, OPTIONAL_FLAG, this.myFlags);
    }

    public boolean isRest() {
        return ByteFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, REST_FLAG, this.myFlags);
    }

    public boolean isTypeExplicitlyDeclared() {
        return ByteFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, EXPLICITLY_DECLARED_FLAG, this.myFlags);
    }

    void serialize(@NotNull DataOutput dataStream) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitParameterStructure", "serialize"));
        }
        IOUtil.writeUTF((DataOutput)dataStream, (String)(this.myName != null ? this.myName : NULL_SERIALIZED_NAME));
        dataStream.writeByte(this.myFlags);
        assert (ByteFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, HAS_TYPE_FLAG, this.myFlags) == (this.myTypeString != null));
        if (this.myTypeString != null) {
            IOUtil.writeUTF((DataOutput)dataStream, (String)this.myTypeString);
        }
    }

    @NotNull
    static JSImplicitParameterStructure deserialize(@NotNull DataInput dataStream) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitParameterStructure", "deserialize"));
        }
        String name = IOUtil.readUTF((DataInput)dataStream);
        if (NULL_SERIALIZED_NAME.equals(name)) {
            name = null;
        }
        byte flags = dataStream.readByte();
        boolean notNullType = ByteFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, HAS_TYPE_FLAG, flags);
        String typeString = null;
        if (notNullType) {
            typeString = IOUtil.readUTF((DataInput)dataStream);
        }
        JSImplicitParameterStructure jSImplicitParameterStructure = new JSImplicitParameterStructure(name, typeString, flags);
        if (jSImplicitParameterStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitParameterStructure", "deserialize"));
        }
        return jSImplicitParameterStructure;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof JSImplicitParameterStructure)) {
            return false;
        }
        JSImplicitParameterStructure other = (JSImplicitParameterStructure)obj;
        return StringUtil.equals((CharSequence)this.myName, (CharSequence)other.myName) && this.myFlags == other.myFlags;
    }

    public int hashCode() {
        return this.myName != null ? this.myName.hashCode() : 0;
    }
}

